/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.common.function.ExceptionUnaryOperator;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServer;

public final class AuthenticationContextSaslServer
extends AbstractDelegatingSaslServer {
    private AuthenticationContext context;
    private ExceptionUnaryOperator<byte[], SaslException> responseAction = this.delegate::evaluateResponse;

    public AuthenticationContextSaslServer(SaslServer delegate, AuthenticationContext context) {
        super(delegate);
        this.context = context;
    }

    public AuthenticationContextSaslServer(SaslServer delegate) {
        super(delegate);
        this.context = AuthenticationContext.captureCurrent();
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return (byte[])this.context.runExFunction(this.responseAction, response);
    }

    @Override
    public void dispose() throws SaslException {
        try {
            super.dispose();
        }
        finally {
            this.context = null;
            this.responseAction = null;
        }
    }
}

