/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import javax.jms.Topic;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ExternalJMSTopicService
implements Service<Topic> {
    private final String name;
    static final String JMS_TOPIC_PREFIX = "jms.topic.";
    private Topic topic;

    public ExternalJMSTopicService(String name) {
        this.name = name;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.topic = ActiveMQJMSClient.createTopic((String)(JMS_TOPIC_PREFIX + this.name));
    }

    public synchronized void stop(StopContext context) {
        this.topic = null;
    }

    public Topic getValue() throws IllegalStateException {
        return this.topic;
    }

    public static ExternalJMSTopicService installService(String name, ServiceName serviceName, ServiceTarget serviceTarget) {
        ExternalJMSTopicService service = new ExternalJMSTopicService(name);
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service);
        serviceBuilder.install();
        return service;
    }
}

