/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.ParserNamespaceSupport;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.util.SAML11ParserUtil;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11NameIdentifierType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;

public class SAML11SubjectParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
        SAML11SubjectType subject = new SAML11SubjectType();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)xmlEvent;
                if (StaxParserUtil.matches((EndElement)endElement, (String)JBossSAMLConstants.SUBJECT.get())) {
                    endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    break;
                }
                throw logger.parserUnknownEndElement(StaxParserUtil.getEndElementName((EndElement)endElement));
            }
            StartElement peekedElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (peekedElement == null) break;
            String tag = StaxParserUtil.getStartElementName((StartElement)peekedElement);
            if ("NameIdentifier".equalsIgnoreCase(tag)) {
                Attribute nameQAtt;
                peekedElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                String val = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                SAML11NameIdentifierType nameID = new SAML11NameIdentifierType(val);
                Attribute formatAtt = peekedElement.getAttributeByName(new QName("Format"));
                if (formatAtt != null) {
                    nameID.setFormat(URI.create(StaxParserUtil.getAttributeValue((Attribute)formatAtt)));
                }
                if ((nameQAtt = peekedElement.getAttributeByName(new QName("NameQualifier"))) != null) {
                    nameID.setNameQualifier(StaxParserUtil.getAttributeValue((Attribute)nameQAtt));
                }
                SAML11SubjectType.SAML11SubjectTypeChoice subChoice = new SAML11SubjectType.SAML11SubjectTypeChoice(nameID);
                subject.setChoice(subChoice);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT_CONFIRMATION.get().equalsIgnoreCase(tag)) {
                SAML11SubjectConfirmationType subjectConfirmationType = SAML11ParserUtil.parseSAML11SubjectConfirmation(xmlEventReader);
                subject.setSubjectConfirmation(subjectConfirmationType);
                continue;
            }
            throw logger.parserUnknownTag(tag, peekedElement.getLocation());
        }
        return subject;
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.ASSERTION_NSURI.get()) && localPart.equals(JBossSAMLConstants.SUBJECT.get());
    }
}

