/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sqs.model.AttributeNameListCopier;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.SqsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueueAttributesRequest
extends SqsRequest
implements ToCopyableBuilder<Builder, GetQueueAttributesRequest> {
    private static final SdkField<String> QUEUE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueUrl").getter(GetQueueAttributesRequest.getter(GetQueueAttributesRequest::queueUrl)).setter(GetQueueAttributesRequest.setter(Builder::queueUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueUrl").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeNames").getter(GetQueueAttributesRequest.getter(GetQueueAttributesRequest::attributeNamesAsStrings)).setter(GetQueueAttributesRequest.setter(Builder::attributeNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build(), ListTrait.builder().memberLocationName("AttributeName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build()).isFlattened(true).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_URL_FIELD, ATTRIBUTE_NAMES_FIELD));
    private final String queueUrl;
    private final List<String> attributeNames;

    private GetQueueAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.attributeNames = builder.attributeNames;
    }

    public final String queueUrl() {
        return this.queueUrl;
    }

    public final List<QueueAttributeName> attributeNames() {
        return AttributeNameListCopier.copyStringToEnum(this.attributeNames);
    }

    public final boolean hasAttributeNames() {
        return this.attributeNames != null && !(this.attributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> attributeNamesAsStrings() {
        return this.attributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeNames() ? this.attributeNamesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueAttributesRequest)) {
            return false;
        }
        GetQueueAttributesRequest other = (GetQueueAttributesRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && this.hasAttributeNames() == other.hasAttributeNames() && Objects.equals(this.attributeNamesAsStrings(), other.attributeNamesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetQueueAttributesRequest").add("QueueUrl", (Object)this.queueUrl()).add("AttributeNames", this.hasAttributeNames() ? this.attributeNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.ofNullable(clazz.cast(this.queueUrl()));
            }
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNamesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQueueAttributesRequest, T> g) {
        return obj -> g.apply((GetQueueAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsRequest.BuilderImpl
    implements Builder {
        private String queueUrl;
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueAttributesRequest model) {
            super(model);
            this.queueUrl(model.queueUrl);
            this.attributeNamesWithStrings(model.attributeNames);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (this.attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNamesWithStrings(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNamesWithStrings(String ... attributeNames) {
            this.attributeNamesWithStrings(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        public final Builder attributeNames(Collection<QueueAttributeName> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copyEnumToString(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(QueueAttributeName ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetQueueAttributesRequest build() {
            return new GetQueueAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SqsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueueAttributesRequest> {
        public Builder queueUrl(String var1);

        public Builder attributeNamesWithStrings(Collection<String> var1);

        public Builder attributeNamesWithStrings(String ... var1);

        public Builder attributeNames(Collection<QueueAttributeName> var1);

        public Builder attributeNames(QueueAttributeName ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

