/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.Font;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.table.DefaultTableModel;
import tecgraf.javautils.gui.print.DefaultPrintableReport;
import tecgraf.javautils.gui.print.DefaultPrintableTable;
import tecgraf.javautils.gui.print.PrintableReportItem;
import tecgraf.javautils.gui.print.PrintableTable;

public class DefaultPrintableReportSample2 {
    private static final int SHIP_COL = 0;
    private static final int SOURCE_COL = 1;
    private static final int ETD_COL = 2;
    private static final int TARGET_COL = 3;
    private static final int ETA_COL = 4;
    private static final int VOLUME_COL = 5;
    private static final Object[] SHIPS = new Object[]{"Norma", "Nilza", "Clara", "Pero", "Restinga", "TBN", "TBN", "TBN", "TBN"};
    private static final Object[] POINTS = new Object[]{"Ilha D'\u00e1gua", "Angra dos Reis", "Mucuripe", "Cabedelo", "Santos", "N/A"};
    private static final Font TITLE_FONT = new Font("Serif", 1, 14);
    private static final Font TABLE_HEADER_FONT = new Font("SansSerif", 2, 8);
    private static final Font POST_TABLE_FONT = new Font("SansSerif", 2, 8);
    private static final Font COL_NAME_FONT = new Font("SansSerif", 1, 9);
    private static final Font SHIP_FONT = new Font("SansSerif", 1, 10);
    private static final Font TOTAL_VOLUME_FONT = new Font("SansSerif", 1, 9);

    public static void main(String[] args) throws PrinterException {
        int numRows = 125;
        int numColumns = 6;
        DefaultTableModel model = DefaultPrintableReportSample2.getTableModel(numRows, numColumns);
        PrintableTable table = DefaultPrintableReportSample2.getPrintableTable(model);
        ArrayList<PrintableReportItem> page = new ArrayList<PrintableReportItem>();
        page.add(table);
        DefaultPrintableReport report = new DefaultPrintableReport(page);
        report.setOrientation(1);
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable(report);
        if (job.printDialog()) {
            job.print();
        }
    }

    public static PrintableTable getPrintableTable(DefaultTableModel model) {
        DefaultPrintableTable table = new DefaultPrintableTable(model);
        table.setTitle("Mapa de Navega\u00e7\u00e3o de Cabotagem\nViagens Programadas", TITLE_FONT);
        table.setTableHeader("Para aloca\u00e7\u00e3o de petr\u00f3leos.\nN\u00e3o considera cabotagem de derivados.", TABLE_HEADER_FONT);
        table.setPosText("Terminal N/A: indefinido.", POST_TABLE_FONT);
        int lastRow = model.getRowCount() - 1;
        int lastCol = model.getColumnCount() - 1;
        table.setColumnNameFont(0, lastCol, COL_NAME_FONT);
        table.setCellFont(0, lastRow, 0, 0, SHIP_FONT);
        table.setCellFont(lastRow, lastRow, 5, 5, TOTAL_VOLUME_FONT);
        table.setDefaultFont(new Font("SansSerif", 0, 9));
        table.setDecimalFormat(new DecimalFormat("#.00"));
        table.setLineWidth(0.0f);
        table.setInsets(1.0f, 1.0f);
        return table;
    }

    private static Object getRandomShip() {
        return SHIPS[(int)Math.floor(Math.random() * (double)SHIPS.length)];
    }

    private static Object getRandomPoint() {
        return POINTS[(int)Math.floor(Math.random() * (double)POINTS.length)];
    }

    private static Object getLastPoint() {
        return POINTS[POINTS.length - 1];
    }

    private static double getRandomVolume() {
        return Math.random() * 1000.0;
    }

    private static Date getRandomETD() {
        int days = (int)Math.floor((Math.random() - 0.5) * 30.0);
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, days);
        return cal.getTime();
    }

    private static Date getRandomETA() {
        int days = (int)Math.floor(Math.random() * 30.0);
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, days);
        return cal.getTime();
    }

    public static DefaultTableModel getTableModel(int numRows, int numColumns) {
        Object[] names = new Object[]{"Navio", "Origem", "ETD", "Destino", "ETA", "Volume\n(1000 m3)"};
        Object[][] data = new Object[numRows][numColumns];
        double totalVolume = 0.0;
        for (int row = 0; row < numRows - 1; ++row) {
            data[row][0] = DefaultPrintableReportSample2.getRandomShip();
            data[row][1] = DefaultPrintableReportSample2.getRandomPoint();
            data[row][3] = DefaultPrintableReportSample2.getRandomPoint();
            if (data[row][1] == data[row][3]) {
                data[row][3] = DefaultPrintableReportSample2.getLastPoint();
            }
            data[row][2] = DefaultPrintableReportSample2.getRandomETD();
            data[row][4] = DefaultPrintableReportSample2.getRandomETA();
            double volume = DefaultPrintableReportSample2.getRandomVolume();
            data[row][5] = volume;
            totalVolume += volume;
        }
        data[numRows - 1][0] = "Total";
        data[numRows - 1][5] = totalVolume;
        DefaultTableModel m1 = new DefaultTableModel(data, names);
        return m1;
    }
}

