/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.helper;

import csdk.v1_0.api.command.CommandException;
import csdk.v1_0.api.command.IAlgorithmTemplate;
import csdk.v1_0.api.command.ICommandContext;
import csdk.v1_0.api.command.ICommandObserver;
import csdk.v1_0.api.command.IFlowTemplate;
import csdk.v1_0.api.core.ICSDKEnvironment;
import csdk.v1_0.api.filesystem.FileSelectionType;
import csdk.v1_0.api.filesystem.IFile;
import csdk.v1_0.api.filesystem.local.ILocalFileSystemContext;
import csdk.v1_0.api.filesystem.local.LocalFileSystemException;
import csdk.v1_0.api.filesystem.project.IProjectContext;
import csdk.v1_0.api.filesystem.project.IProjectObserver;
import csdk.v1_0.api.filesystem.project.ProjectException;
import csdk.v1_0.helper.ContextNotAvailableException;
import csdk.v1_0.helper.application.AbstractApplication;
import java.awt.Window;

public abstract class AbstractCSDKApplication
extends AbstractApplication
implements IProjectContext,
ILocalFileSystemContext,
ICommandContext {
    private IProjectContext projectContext = this.getContext(IProjectContext.class);
    private ILocalFileSystemContext localFileSystemContext = this.getContext(ILocalFileSystemContext.class);
    private ICommandContext commandContext = this.getContext(ICommandContext.class);

    public AbstractCSDKApplication(ICSDKEnvironment csdkInterface) {
        super(csdkInterface);
    }

    @Override
    public final IFile browseProjectFileInOpenMode(String[] fileTypes, boolean allowAll, FileSelectionType selectionType, Window frame) throws ProjectException {
        this.checkProjectContext();
        return this.projectContext.browseProjectFileInOpenMode(fileTypes, allowAll, selectionType, frame);
    }

    @Override
    public IFile[] browseMultipleProjectFilesInOpenMode(String[] fileTypes, boolean allowAll, FileSelectionType selectionType, Window frame) throws ProjectException {
        this.checkProjectContext();
        return this.projectContext.browseMultipleProjectFilesInOpenMode(fileTypes, allowAll, selectionType, frame);
    }

    @Override
    public final IFile browseProjectFileInSaveMode(String[] fileTypes, boolean allowAll, String defaultName, Window frame) throws ProjectException {
        this.checkProjectContext();
        return this.projectContext.browseProjectFileInSaveMode(fileTypes, allowAll, defaultName, frame);
    }

    @Override
    public final IFile getProjectFile(String[] path, Window window) throws ProjectException {
        this.checkProjectContext();
        return this.projectContext.getProjectFile(path, window);
    }

    @Override
    public final IFile createProjectFile(String[] path, String name, String fileType, Window window) throws ProjectException {
        this.checkProjectContext();
        return this.projectContext.createProjectFile(path, name, fileType, window);
    }

    @Override
    public final String getCurrentProjectId() {
        this.checkProjectContext();
        return this.projectContext.getCurrentProjectId();
    }

    @Override
    public void addProjectObserver(IProjectObserver observer) {
        this.checkProjectContext();
        this.projectContext.addProjectObserver(observer);
    }

    @Override
    public void removeProjectObserver(IProjectObserver observer) {
        this.checkProjectContext();
        this.projectContext.removeProjectObserver(observer);
    }

    @Override
    public boolean removeProjectFile(String[] path, Window window) throws ProjectException {
        this.checkProjectContext();
        return this.projectContext.removeProjectFile(path, window);
    }

    @Override
    public final IFile browseLocalFileInOpenMode(String[] fileTypes, boolean allowAll, IFile currentDir, FileSelectionType fileSelectionType, Window frame) throws LocalFileSystemException {
        this.checkFileSystemContext();
        return this.localFileSystemContext.browseLocalFileInOpenMode(fileTypes, allowAll, currentDir, fileSelectionType, frame);
    }

    @Override
    public IFile[] browseMultipleLocalFilesInOpenMode(String[] fileTypes, boolean allowAll, IFile currentDir, FileSelectionType fileSelectionType, Window frame) throws LocalFileSystemException {
        this.checkFileSystemContext();
        return this.localFileSystemContext.browseMultipleLocalFilesInOpenMode(fileTypes, allowAll, currentDir, fileSelectionType, frame);
    }

    @Override
    public final IFile browseLocalFileInSaveMode(String[] fileTypes, boolean allowAll, String defaultName, IFile currentDir, Window frame) throws LocalFileSystemException {
        this.checkFileSystemContext();
        return this.localFileSystemContext.browseLocalFileInSaveMode(fileTypes, allowAll, defaultName, currentDir, frame);
    }

    @Override
    public IFile getLocalFile(String[] path) throws LocalFileSystemException {
        this.checkFileSystemContext();
        return this.localFileSystemContext.getLocalFile(path);
    }

    @Override
    public final IFile createLocalFile(String[] path, String name, boolean isDir) throws LocalFileSystemException {
        this.checkFileSystemContext();
        return this.localFileSystemContext.createLocalFile(path, name, isDir);
    }

    @Override
    public boolean removeLocalFile(String[] path) throws LocalFileSystemException {
        this.checkFileSystemContext();
        return this.localFileSystemContext.removeLocalFile(path);
    }

    @Override
    public final String executeAlgorithm(IAlgorithmTemplate info, String description, String sgaServerName, Window owner, ICommandObserver observer) throws CommandException {
        this.checkCommandContext();
        return this.commandContext.executeAlgorithm(info, description, sgaServerName, owner, observer);
    }

    @Override
    public final String executeFlow(IFlowTemplate info, String description, String sgaServerName, Window owner, ICommandObserver observer) throws CommandException {
        this.checkCommandContext();
        return this.commandContext.executeFlow(info, description, sgaServerName, owner, observer);
    }

    public boolean isProjectContextAvailable() {
        return this.projectContext != null && this.projectContext.isActive();
    }

    public boolean isProjectOpen() {
        return this.isProjectContextAvailable() && this.getCurrentProjectId() != null;
    }

    public boolean isFileSystemContextAvailable() {
        return this.localFileSystemContext != null && this.localFileSystemContext.isActive();
    }

    public boolean isCommandContextAvailable() {
        return this.commandContext != null && this.commandContext.isActive();
    }

    private void checkProjectContext() {
        if (!this.isProjectContextAvailable()) {
            throw new ContextNotAvailableException(IProjectContext.class);
        }
    }

    private void checkFileSystemContext() {
        if (!this.isFileSystemContextAvailable()) {
            throw new ContextNotAvailableException(ILocalFileSystemContext.class);
        }
    }

    private void checkCommandContext() {
        if (!this.isCommandContextAvailable()) {
            throw new ContextNotAvailableException(ICommandContext.class);
        }
    }

    @Override
    protected void disposeContexts() {
        super.disposeContexts();
        this.commandContext = null;
        this.localFileSystemContext = null;
        this.projectContext = null;
    }
}

