/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLProtocolConverter;
import java.io.Serializable;
import java.util.regex.Pattern;
import tecgraf.javautils.core.io.FileUtils;

public final class FileURLValue
implements Comparable<FileURLValue>,
Serializable,
Cloneable {
    protected static final String PATH_SEPARATOR = "/";
    protected String path;
    protected String type;
    public static final URLProtocol DEFAULT_PROTOCOL = URLProtocol.PROJECT;
    private String host;
    private URLProtocol protocol;

    public FileURLValue(String path) {
        this(path, "UNKNOWN");
    }

    public FileURLValue(String path, String type) {
        this(path, type, URLProtocol.PROJECT);
    }

    public FileURLValue(String path, String type, URLProtocol protocol) {
        this(path, type, protocol, null);
    }

    public FileURLValue(String path, String type, URLProtocol protocol, String host) {
        this.setPath(path);
        this.setType(type);
        this.setProtocol(protocol);
        this.setHost(host);
    }

    @Override
    public int compareTo(FileURLValue file) {
        return this.getPath().compareToIgnoreCase(file.getPath());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        FileURLValue other = (FileURLValue)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return this.protocol == other.protocol;
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(char fileSeparator) {
        return this.path.replace(PATH_SEPARATOR, String.valueOf(fileSeparator));
    }

    public String[] getPathAsArray() {
        return FileUtils.splitPath((String)this.path, (String)PATH_SEPARATOR);
    }

    public String getType() {
        return this.type;
    }

    public boolean isDirectory() {
        return this.getType().equals("DIRECTORY_TYPE");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public String toString() {
        if (this.path.equals(".")) {
            return PATH_SEPARATOR;
        }
        return this.path;
    }

    public boolean isRegularFile() {
        return !this.isDirectory();
    }

    public boolean isTypeKnown() {
        return this.getType().equals("UNKNOWN");
    }

    public void setPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("O par\u00e2metro path est\u00e1 nulo.");
        }
        String auxPath = path.length() == 0 ? "." : path.replaceAll("\\\\", PATH_SEPARATOR);
        this.path = auxPath;
    }

    private void setType(String newType) {
        String auxType = newType;
        if (newType == null || newType.trim().isEmpty()) {
            auxType = "UNKNOWN";
        }
        this.type = auxType;
    }

    public FileURLValue clone() {
        return new FileURLValue(this.path, this.type, this.protocol, this.host);
    }

    public URLProtocol getProtocol() {
        return this.protocol;
    }

    private void setProtocol(URLProtocol protocol) {
        this.protocol = protocol == null ? DEFAULT_PROTOCOL : protocol;
    }

    public String getHost() {
        return this.host;
    }

    private void setHost(String host) {
        this.host = host;
    }

    public static boolean isWindowsAbsolutePath(String urlValue) {
        if (urlValue == null) {
            return false;
        }
        String windowsAbsolutePathPattern = "^\\w:\\\\.*";
        String windowsAbsolutePathWithUnixSeparatorPattern = "^\\w:/.*";
        boolean isWinPath = Pattern.matches(windowsAbsolutePathPattern, urlValue) || Pattern.matches(windowsAbsolutePathWithUnixSeparatorPattern, urlValue);
        return isWinPath;
    }

    public static boolean isAbsolutePath(String urlValue) {
        if (urlValue == null) {
            return false;
        }
        return FileURLValue.isWindowsAbsolutePath(urlValue) || urlValue.startsWith(PATH_SEPARATOR);
    }

    static FileURLValue getURLFromString(FileParameterMode mode, String stringValue) {
        if (stringValue == null || stringValue.length() == 0) {
            return null;
        }
        String[] fileValue = stringValue.split(":");
        String path = null;
        String type = null;
        String protocol = null;
        String host = null;
        int groupIndex = 0;
        if (FileURLValue.isWindowsAbsolutePath(stringValue)) {
            path = fileValue[groupIndex++] + ":" + fileValue[groupIndex++];
        } else if (fileValue.length > groupIndex) {
            path = fileValue[groupIndex++];
        }
        if (fileValue.length > groupIndex) {
            type = fileValue[groupIndex++];
        }
        if (fileValue.length > groupIndex) {
            protocol = fileValue[groupIndex++];
        }
        if (fileValue.length > groupIndex) {
            host = fileValue[groupIndex++];
        }
        if (type == null || type.trim().isEmpty()) {
            type = mode == FileParameterMode.DIRECTORY ? "DIRECTORY_TYPE" : "UNKNOWN";
        }
        URLProtocol urlProtocol = FileURLValue.getProtocolFromString(protocol);
        FileURLValue value = new FileURLValue(path, type, urlProtocol, host);
        return value;
    }

    static String getStringValue(FileURLValue file) {
        String host;
        if (file == null) {
            return null;
        }
        String type = file.getType();
        if (type == null || type.trim().isEmpty()) {
            type = "UNKNOWN";
        }
        StringBuilder valueAsText = new StringBuilder();
        valueAsText.append(file.getPath());
        valueAsText.append(":");
        valueAsText.append(type);
        URLProtocol protocol = file.getProtocol();
        if (protocol != null) {
            valueAsText.append(":");
            valueAsText.append(protocol.getType());
        }
        if ((host = file.getHost()) != null) {
            valueAsText.append(":");
            valueAsText.append(host);
        }
        return valueAsText.toString();
    }

    private static URLProtocol getProtocolFromString(String protocolString) {
        URLProtocol urlProtocol = null;
        URLProtocolConverter converter = new URLProtocolConverter();
        if (protocolString != null) {
            try {
                urlProtocol = converter.valueOf(protocolString);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Protocolo de arquivo inv\u00e1lido: " + protocolString);
            }
        }
        return urlProtocol;
    }
}

