/**
 * $Id: ProjectObserver.java 146209 2013-10-28 14:34:28Z fpina $
 */
package csbase.logic;

import java.rmi.RemoteException;

/**
 * Interface que modela um observador de projetos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface ProjectObserver {
  /**
   * Registra no servidor um observador.
   * 
   * @throws RemoteException Em caso de falha.
   */
  void install() throws RemoteException;

  /**
   * Remove do servidor o registro desse observador.
   * 
   * @throws RemoteException Em caso de falha.
   */
  void uninstall() throws RemoteException;
}
