/*
 * AlgorithmOutline.java
 * $Author: lmoreira $
 * $Revision: 55236 $  - $Date: 2006-08-23 09:36:34 -0300 (Wed, 23 Aug 2006) $
 */
package csbase.logic.algorithms;

import java.io.Serializable;

/**
 * A classe <code>AlgorithmOutline</code> representa informaes resumidas de
 * um algoritmo: identificador, nome e data da ltima atualizao
 *
 * @author Ana
 * @version $Revision: 55236 $
 */
public final class AlgorithmOutline implements Serializable {
  /** Identificador do algoritmo */
  private Object id;

  /** Nome do algoritmo. */
  private String name;

  /**
   * Obtm o identificador.
   *
   * @return a identificao
   */
  public Object getId() {
    return this.id;
  }

  /**
   * Obtm o nome do algoritmo.
   *
   * @return o nome do algoritmo
   */
  public String getName() {
    return this.name;
  }

  /**
   * Cria um resumo de um algoritmo.
   *
   * @param id identificador do algoritmo
   * @param name nome do algoritmo
   */
  public AlgorithmOutline(Object id, String name) {
    this.id = id;
    this.name = name;
  }
}
