/*
 * $Author$ $Date$ $Revision$
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.CommandLineContext;

/**
 * <p>
 * Implementao padro de Item de enumerao
 * </p>
 * 
 * @author lmoreira
 */
public final class DefaultEnumerationItem extends AbstractEnumerationItem {
  /**
   * A descrio deste item (Pode no existir).
   */
  private String description;

  /**
   * O identificador deste item.
   */
  private String id;

  /**
   * O rtulo deste item.
   */
  private String label;

  /**
   * O valor deste item.
   */
  private String value;

  /**
   * Cria um item de enumerao.
   * 
   * @param id O identificador do item (No aceita {@code null}).
   * @param name O nome do item (No aceita {@code null}).
   * @param value O valor do item (No aceita {@code null}).
   * @param description A descrio do item ((Aceita {@code null}).
   */
  public DefaultEnumerationItem(String id, String name, String value,
    String description) {
    setId(id);
    setLabel(name);
    setValue(value);
    this.description = description;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getDescription() {
    return this.description;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getId() {
    return this.id;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getLabel() {
    return this.label;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getCommandValue(CommandLineContext context) {
    return getValue();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getValue() {
    return this.value;
  }

  /**
   * Atribui um identificador a este item.
   * 
   * @param id O identificador (No aceita {@code null}).
   */
  private void setId(String id) {
    if (id == null) {
      throw new IllegalArgumentException("O parmetro id est nulo.");
    }
    this.id = id;
  }

  /**
   * Atribui um rtulo a este item.
   * 
   * @param label O rtulo (No aceita {@code null}).
   */
  private void setLabel(String label) {
    if (label == null) {
      throw new IllegalArgumentException("O parmetro label est nulo.");
    }
    this.label = label;
  }

  /**
   * Atribui um valor a este item.
   * 
   * @param value O valor (No aceita {@code null}).
   */
  private void setValue(String value) {
    if (value == null) {
      throw new IllegalArgumentException("O parmetro value est nulo.");
    }
    this.value = value;
  }
}
