package csbase.logic.algorithms.parameters.conditions;

import csbase.exception.ParseException;
import csbase.exception.algorithms.FormulaCreationException;
import csbase.exception.algorithms.FormulaEvaluationException;
import csbase.logic.algorithms.parameters.Expression;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;

/**
 * <p>
 * Condio genrica.
 * </p>
 * 
 * <p>
 * A condio genrica possui uma expresso boleana construda por qualquer
 * combinao de operadores relacionais, aritmticos e lgicos.
 * </p>
 * 
 * @author lmoreira
 */
public final class GenericCondition implements Condition {

  /**
   * A expresso.
   */
  private final Expression expression;

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(final Object obj) {
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    final GenericCondition other = (GenericCondition) obj;
    return this.expression.equals(other.expression);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean evaluate(final SimpleAlgorithmConfigurator configurator) {
    try {
      return this.expression.evaluate(configurator);
    }
    catch (final FormulaEvaluationException e) {
      for (Throwable cause = e; (cause != null && cause != cause.getCause()); cause =
        cause.getCause()) {
        cause.printStackTrace();
      }
      return false;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    return this.expression.hashCode();
  }

  /**
   * Cria a condio.
   * 
   * @param expressionText A expresso.
   * 
   * @throws FormulaCreationException Erro ao criar a expresso.
   * @throws ParseException Erro ao criar a expresso.
   */
  public GenericCondition(final String expressionText)
    throws FormulaCreationException, ParseException {
    this.expression = new Expression(expressionText);
  }
}
