package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.conditions.Condition;

/**
 * Gatilho Ocultar Grupo: Oculta o {@link ParameterGroup parmetro} quando a
 * {@link Condition condio} associada for aceita.</p>
 */
public class HideGroupTrigger extends Trigger<ParameterGroup> {

  /**
   * Cria o gatilho.
   * 
   * @param group O grupo (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   */
  public HideGroupTrigger(ParameterGroup group, Condition condition) {
    super(group, condition);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doAction() {
    getParameter().setVisible(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void undoAction() {
    getParameter().setVisible(true);
  }

}
