package csbase.logic.algorithms.parsers;

import java.util.ArrayList;
import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.ProjectFileType;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.FileURLValue;

/**
 * <p>
 * Analisador de {@link InputFileListParameter}.
 * </p>
 *
 * <p>
 * Este parser l os atributos de parmetros do tipo "arquivo de entrada"
 * mltiplo. O elemento corrente do {@link XmlParser analisador de XML} precisa
 * ser um elemento {@link InputFileListParameter}.
 * </p>
 *
 */
class InputFileListParameterParser extends
AbstractFileParameterParser<InputFileListParameter> {

  /**
   * {@inheritDoc}
   */
  @Override
  public InputFileListParameter createFileParameter(XmlParser parser,
    String name, String label, String description, boolean isOptional,
    boolean isVisible, String commandLinePattern, String type, FileParameterMode mode)
      throws ParseException {

    final boolean pipeDefined =
      parser.hasAttributeValue(FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_ATTRIBUTE);
    if (pipeDefined) {
      final FileParameterPipeAcceptance usesPipe =
        parser.extractAttributeValueAsEnumeration(
          FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_ATTRIBUTE,
          new FileParameterPipeAcceptanceConverter());
      if (usesPipe == FileParameterPipeAcceptance.TRUE
        || usesPipe == FileParameterPipeAcceptance.ALWAYS) {
        throw new ParseException(
          "Arquivo de entrada (seleo mltipla) no admite pipes");
      }
    }

    boolean useRootDirectoryAsDefault =
      parser.extractAttributeValueAsBoolean(
        FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_ATTRIBUTE,
        FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_DEFAULT_VALUE);
    List<FileURLValue> defaultValue = null;
    if (useRootDirectoryAsDefault) {
      if (mode == FileParameterMode.REGULAR_FILE) {
        throw new ParseException(
          "O atributo {0}  invlido quando o parmetro de entrada  um arquivo.",
          new Object[] { FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_ATTRIBUTE });
      }
      defaultValue = new ArrayList<FileURLValue>();
      defaultValue.add(new FileURLValue(".", ProjectFileType.DIRECTORY_TYPE));
    }

    boolean mustSort =
      parser.extractAttributeValueAsBoolean(
        FILE_PARAMETER_ELEMENT_MUST_SORT_ATTRIBUTE,
        FILE_PARAMETER_ELEMENT_MUST_SORT_DEFAULT_VALUE);

    boolean useFilter =
      parser.extractAttributeValueAsBoolean(
        FILE_PARAMETER_ELEMENT_USE_FILTER_ATTRIBUTE,
        FILE_PARAMETER_ELEMENT_USE_FILTER_DEFAULT_VALUE);

    InputFileListParameter parameter =
      new InputFileListParameter(name, label, description, defaultValue,
        isOptional, isVisible, commandLinePattern, type, mode, mustSort,
        useFilter);
    return parameter;
  }

  @Override
  protected boolean acceptBothCategory() {
    return true;
  }
}
