package csbase.logic.algorithms.parsers;

import csbase.logic.algorithms.parameters.OutputFileListParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;

/**
 * 
 * <p>
 * Fbrica de parmetros do tipo "arquivo de sada": {@link OutputFileParameter}
 * e {@link OutputFileListParameter}. Como esses dois parmetros podem ser
 * criados a partir de uma mesma tag XML, essa fbrica foi criada para
 * direcionar a anlise para o parser apropriado para cada um dos casos.
 * </p>
 * 
 * <p>
 * O elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link OutputFileParameterParser#OUTPUT_FILE_PARAMETER_ELEMENT}.
 * </p>
 * 
 */
public class OutputFileParameterFactory extends FileParameterFactory {

  /**
   * {@inheritDoc}
   */
  @Override
  protected OutputFileListParameterParser createFileListParser() {
    return new OutputFileListParameterParser();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected OutputFileParameterParser createSimpleFileParser() {
    return new OutputFileParameterParser();
  }

}
