package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.ChangeFileTypeTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.InputFileParameterParser;
import csbase.logic.algorithms.parsers.OutputFileParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;

/**
 * Fbrica de {@link ChangeFileTypeTrigger}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class ChangeFileTypeTriggerFactory extends
  AbstractSimpleTriggerFactory {
  /**
   * Atributo {@value #NEW_FILE_TYPE_ATTRIBUTE}: indica o novo tipo do arquivo,
   *  opcional e  do tipo string.
   */
  private static final String NEW_FILE_TYPE_ATTRIBUTE = "novo_tipo";

  /**
   * Cria a fbrica.
   */
  public ChangeFileTypeTriggerFactory() {
    super("trocar_tipo_de_arquivo", false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Trigger<?> doCreateTrigger(XmlParser parser, Condition condition,
    Parameter<?> parameter, SimpleAlgorithmConfigurator configurator)
      throws ParseException {
    if (!(parameter instanceof FileParameter)) {
      throw new ParseException("O parmetro {0} no  de um tipo vlido.\n"
        + "Tipos permitidos:\n{1};\n{2}.", parameter.getName(),
        InputFileParameterParser.INPUT_FILE_PARAMETER_ELEMENT,
        OutputFileParameterParser.OUTPUT_FILE_PARAMETER_ELEMENT);
    }
    String newFileType = parser.extractAttributeValue(NEW_FILE_TYPE_ATTRIBUTE,
      null);
    return new ChangeFileTypeTrigger((FileParameter) parameter, condition,
      newFileType);
  }
}
