package csbase.logic.filters;

import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileFilter;

/**
 * Define um filtro que sempre retorna verdadeiro.
 * 
 * @author Tecgraf
 */
public final class ProjectFileTrueFilter implements ProjectFileFilter {
  /**
   * Instncia do filtro.
   */
  private static final ProjectFileTrueFilter instance =
    new ProjectFileTrueFilter();

  /**
   * Construtor.
   */
  private ProjectFileTrueFilter() {
    // vazio
  }

  /**
   * @return instncia do filtro
   */
  public static ProjectFileTrueFilter getInstance() {
    return instance;
  }

  /**
   * {@inheritDoc}
   */
  public boolean accept(ClientProjectFile file) {
    return true;
  }
}