/*
 * $Id:
 */

package csbase.logic.openurlservice;

import java.io.Serializable;

import csbase.remote.OpenURLServiceInterface;

/**
 * Identificao de sistemas predefinidos acessveis pelo servio
 * {@link OpenURLServiceInterface}
 * 
 * @author Tecgraf/PUC-Rio
 */
public class PredefinedURLSystem implements Serializable {

  /**
   * Rtulo
   */
  final private String label;

  /**
   * Endereo IP (nome ou quad)
   */
  final private String hostAddress;

  /**
   * Porta
   */
  final private int hostPort;

  /**
   * Consulta o atributo (ver documentao de {@link #hostAddress}).
   * 
   * @return o atributo.
   */
  public final String getHostAddress() {
    return hostAddress;
  }

  /**
   * Consulta o atributo (ver documentao de {@link #hostPort}).
   * 
   * @return o atributo.
   */
  public final int getHostPort() {
    return hostPort;
  }

  /**
   * Consulta o atributo (ver documentao de {@link #label}).
   * 
   * @return o atributo.
   */
  public final String getLabel() {
    return label;
  }

  /**
   * Construtor
   * 
   * @param label rtulo (nome)
   * @param hostAddress endereo da mquina
   * @param hostPort porta na mquina do servidor (sistema)
   */
  public PredefinedURLSystem(final String label, final String hostAddress,
    final int hostPort) {
    super();
    this.label = label;
    this.hostAddress = hostAddress;
    this.hostPort = hostPort;
  }

}
