/**
 * $Id$
 */
package csbase.remote;

import java.rmi.RemoteException;
import java.util.TimeZone;

import csbase.exception.CSBaseException;
import csbase.logic.Session;

/**
 * Representa um autenticador de usurios no servidor atravs do mtodo de
 * <b>pr-login</b>.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class PreLoginAuthenticator implements Authenticator {
  /**
   * O token obtido em uma operao de pr-login.
   */
  private String token;

  /**
   * Cria um autenticador de usurios no servidor atravs do mtodo de
   * <b>pr-login</b>
   * 
   * @param token O token obtido em uma operao de pr-login.
   */
  public PreLoginAuthenticator(String token) {
    this.token = token;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Session authenticate(ServerEntryPoint server) throws CSBaseException {
    TimeZone tz = TimeZone.getDefault();
    try {
      return server.login(this.token, tz);
    }
    catch (RemoteException e) {
      throw new CSBaseException(e);
    }
  }

}
