/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.ChangeMinimumForDoublesTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeMinimumForIntegersTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.triggers.AbstractSimpleTriggerFactory;

public final class ChangeMinimumTriggerFactory
extends AbstractSimpleTriggerFactory {
    private static final String INCLUDE_NEW_MINIMUM_ATTRIBUTE = "incluir_novo_minimo";
    private static final boolean INCLUDE_NEW_MINIMUM_DEFAULT_VALUE = true;
    private static final String NEW_MINIMUM_ATTRIBUTE = "novo_minimo";

    public ChangeMinimumTriggerFactory() {
        super("trocar_minimo", false);
    }

    @Override
    protected Trigger<?> doCreateTrigger(XmlParser parser, Condition condition, Parameter<?> parameter, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Trigger trigger;
        if (parameter instanceof DoubleParameter) {
            Double minimum = parser.extractAttributeValueAsDouble(NEW_MINIMUM_ATTRIBUTE, null);
            boolean isMinimumIncluded = parser.extractAttributeValueAsBoolean(INCLUDE_NEW_MINIMUM_ATTRIBUTE, true);
            DoubleParameter doubleParameter = (DoubleParameter)parameter;
            trigger = new ChangeMinimumForDoublesTrigger(doubleParameter, condition, minimum, isMinimumIncluded);
        } else if (parameter instanceof DoubleListParameter) {
            Double minimum = parser.extractAttributeValueAsDouble(NEW_MINIMUM_ATTRIBUTE, null);
            boolean isMinimumIncluded = parser.extractAttributeValueAsBoolean(INCLUDE_NEW_MINIMUM_ATTRIBUTE, true);
            DoubleListParameter doubleListParameter = (DoubleListParameter)parameter;
            trigger = new ChangeMinimumForDoublesTrigger(doubleListParameter, condition, minimum, isMinimumIncluded);
        } else if (parameter instanceof IntegerParameter) {
            Integer minimum = parser.extractAttributeValueAsInteger(NEW_MINIMUM_ATTRIBUTE, null);
            IntegerParameter integerParameter = (IntegerParameter)parameter;
            trigger = new ChangeMinimumForIntegersTrigger(integerParameter, condition, minimum);
        } else if (parameter instanceof IntegerListParameter) {
            Integer minimum = parser.extractAttributeValueAsInteger(NEW_MINIMUM_ATTRIBUTE, null);
            IntegerListParameter integerListParameter = (IntegerListParameter)parameter;
            trigger = new ChangeMinimumForIntegersTrigger(integerListParameter, condition, minimum);
        } else {
            throw new ParseException("O par\u00e2metro {0} n\u00e3o \u00e9 de um tipo v\u00e1lido.\nTipos permitidos:\n{1};\n{2};\n{3};\n{4}..", parameter.getName(), "real", "lista_de_reais", "inteiro", "lista_de_inteiros");
        }
        return trigger;
    }
}

