/**
 * $Id: StatusCode.java 140743 2013-05-09 13:35:50Z fpina $
 */
package csbase.logic.diagnosticservice;

import java.io.Serializable;

/**
 * Cdigos de estado. Podem ser:
 * <ul>
 * <li>OK: recurso est ativo</li>
 * <li>NOT_MONITORED: recurso foi desabilitado para monitorao</li>
 * <li>ERROR: ocorreu algum erro ao obter o estado do recurso</li>
 * <li>UNAVAILABLE: recurso indisponvel</li>
 * <li>INITIATING: monitor est obtendo o estado inicial do recurso</li>
 * </ul>
 * 
 * @author Tecgraf PUC-Rio
 */
public enum StatusCode implements Serializable {
  /**
   * O recurso est ativo e disponvel
   */
  OK,
  /**
   * O recurso foi desabilitado para monitorao
   */
  NOT_MONITORED,
  /**
   * Ocorreu algum erro ao obter o estado do recurso
   */
  ERROR,
  /**
   * Ocorreu algum alerta ao obter o estado do recurso
   */
  WARNING,
  /**
   * Recurso est indisponvel
   */
  UNAVAILABLE,
  /**
   * O monitor est obtendo o estado inicial do recurso
   */
  INITIATING,
  /**
   * Desconhecido
   */
  UNKNOWN
}
