/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.exception.BugException;
import csbase.logic.EncryptedPassword;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAKeyGenParameterSpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public final class LoginPasswordCipher {
    private static final String ALGORITHM = "RSA/ECB/PKCS1Padding";

    private LoginPasswordCipher() {
    }

    public static KeyPair generateKeyPair() throws BugException {
        try {
            KeyPairGenerator rsaKeyPairGenerator = KeyPairGenerator.getInstance("RSA");
            RSAKeyGenParameterSpec spec = new RSAKeyGenParameterSpec(1024, RSAKeyGenParameterSpec.F4);
            rsaKeyPairGenerator.initialize(spec);
            return rsaKeyPairGenerator.generateKeyPair();
        }
        catch (Exception exception) {
            throw new BugException("Erro ao gerar o par de chaves p\u00fablica e privada.", exception);
        }
    }

    public static EncryptedPassword encrypt(String plainPassword, PublicKey publicKey) throws BugException {
        try {
            Cipher rsaCipher = Cipher.getInstance(ALGORITHM);
            rsaCipher.init(1, publicKey);
            byte[] passwordBytes = plainPassword.getBytes("UTF-8");
            byte[] encryptedPasswordBytes = rsaCipher.doFinal(passwordBytes);
            byte[] passwordEncoded = Base64.encodeBase64((byte[])encryptedPasswordBytes);
            String password = new String(passwordEncoded, "UTF-8");
            return new EncryptedPassword(password);
        }
        catch (Exception exception) {
            throw new BugException("Erro ao criptografar a senha do login.", exception);
        }
    }

    public static String decrypt(EncryptedPassword encryptedPassword, PrivateKey privateKey) throws BugException {
        try {
            Cipher rsaCipher = Cipher.getInstance(ALGORITHM);
            rsaCipher.init(2, privateKey);
            byte[] decoded = Base64.decodeBase64((byte[])encryptedPassword.getPassword().getBytes("UTF-8"));
            byte[] decryptedBytes = rsaCipher.doFinal(decoded);
            String decryptedPassword = new String(decryptedBytes, "UTF-8");
            return decryptedPassword;
        }
        catch (Exception exception) {
            throw new BugException("Erro ao descriptografar a senha do login.", exception);
        }
    }
}

