/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleParameterListener;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.DoubleParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import java.util.List;
import tecgraf.openbus.algorithmservice.v1_0.parameters.DoubleParameterHelper;

public final class DoubleParameter
extends SimpleParameter<Double> {
    public static final double ERROR_VALUE = Double.NaN;
    private boolean isMaximumIncluded;
    private boolean isMinimumIncluded;
    private Double maximum;
    private Double minimum;
    private transient List<DoubleParameterListener> listeners = new LinkedList<DoubleParameterListener>();

    public DoubleParameter(String name, String label, String description, Double defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, Double maximum, boolean isMaximumIncluded, Double minimum, boolean isMinimumIncluded) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern);
        this.setMaximum(maximum, isMaximumIncluded);
        this.setMinimum(minimum, isMinimumIncluded);
    }

    public void addDoubleParameterListener(DoubleParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    @Override
    public Object getExpressionValue() {
        return this.getValue();
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    @Override
    public String getType() {
        return "DOUBLE";
    }

    @Override
    public String getIDLType() {
        return DoubleParameterHelper.id();
    }

    public boolean isMaximumIncluded() {
        return this.isMaximumIncluded;
    }

    public boolean isMinimumIncluded() {
        return this.isMinimumIncluded;
    }

    public boolean setMaximum(Double maximum, boolean maximumIncluded) {
        if (this.minimum != null && maximum != null && maximum.compareTo(this.minimum) < 0) {
            throw new IllegalArgumentException("O valor m\u00e1ximo n\u00e3o pode ser menor do que o valor m\u00ednimo.");
        }
        boolean maxIncluded = maximumIncluded;
        if (maximum == null) {
            if (this.maximum == null) {
                return false;
            }
            maxIncluded = false;
        } else if (maximum.equals(this.maximum)) {
            return false;
        }
        this.isMaximumIncluded = maxIncluded;
        this.maximum = maximum;
        this.updateValidator();
        for (DoubleParameterListener listener : this.listeners) {
            listener.maximumWasChanged(this);
        }
        return true;
    }

    public boolean setMinimum(Double minimum, boolean minimumIncluded) {
        if (this.maximum != null && minimum != null && minimum.compareTo(this.maximum) > 0) {
            throw new IllegalArgumentException("O valor m\u00ednimo n\u00e3o pode ser maior do que o valor m\u00e1ximo.");
        }
        boolean minIncluded = minimumIncluded;
        if (minimum == null) {
            if (this.minimum == null) {
                return false;
            }
            minIncluded = false;
        } else if (minimum.equals(this.minimum)) {
            return false;
        }
        this.isMinimumIncluded = minIncluded;
        this.minimum = minimum;
        this.updateValidator();
        for (DoubleParameterListener listener : this.listeners) {
            listener.minimumWasChanged(this);
        }
        return true;
    }

    private void updateValidator() {
        DoubleParameterValidator validator = (DoubleParameterValidator)this.getParameterValidator();
        validator.setMaximum(this.maximum, this.isMaximumIncluded);
        validator.setMinimum(this.minimum, this.isMinimumIncluded);
    }

    @Override
    public void setValueAsText(String parameterValue) throws ParseException {
        if (parameterValue != null) {
            Double value;
            try {
                value = new Double(Double.parseDouble(parameterValue));
            }
            catch (NumberFormatException e) {
                throw new ParseException(e, "N\u00e3o \u00e9 poss\u00edvel atribuir o valor {0} a um par\u00e2metro do tipo real.\nPar\u00e2metro envolvido: {1}.\n", parameterValue, this);
            }
            this.setValue(value);
        } else {
            this.setValue(null);
        }
    }

    public DoubleParameterValidator createParameterValidator() {
        return new DoubleParameterValidator(this.isOptional(), this.maximum, this.isMaximumIncluded, this.minimum, this.isMinimumIncluded);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList<DoubleParameterListener>();
    }
}

