/*
 * UserUpdate.java
 * 
 * $Author: jorgeads $ $Revision: 79221 $ - $Date: 2004-04-15 11:21:24 -0300
 * (Qui, 15 Abr 2004) $
 */
package csbase.logic;

import java.io.Serializable;

/**
 * A classe <code>UserUpdate</code> representa informaes resumidas de
 * atualizao de um usurio: a identificao e a data da ltima atualizao.
 */
public class UserUpdate implements Serializable {
  private Object userId;
  private long lastUpdate;

  /**
   * Obtm a identificao do usurio.
   * 
   * @return a identificao do usuario
   */
  public Object getId() {
    return userId;
  }

  /**
   * Obtm a data da ltima atualizao de um usurio.
   * 
   * @return a data da ltima atualizao de um usurio em milisegundos desde
   *         1/1/1970.
   */
  public long getLastUpdate() {
    return lastUpdate;
  }

  /**
   * Cria um resumo de atualizao de um usurio.
   * 
   * @param user o usurio
   */
  public UserUpdate(User user) {
    userId = user.getId();
    lastUpdate = user.getLastUpdate();
  }

  /**
   * Cria um resumo de atualizao de um usurio.
   * 
   * @param userId login do usurio.
   * @param lastUpdate data da ltima atualizao de um usurio.
   */
  public UserUpdate(Object userId, long lastUpdate) {
    this.userId = userId;
    this.lastUpdate = lastUpdate;
  }
}
