package csbase.logic.algorithms.parameters.triggers;

import java.text.MessageFormat;

import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;

/**
 * Gatilho Trocar Mnimo para Parmetros com Nmeros Inteiros: Modifica o valor
 * mnimo para parmetro do tipo {@link IntegerParameter Inteiro},
 * {@link IntegerListParameter Lista de Inteiros} quando a {@link Condition
 * condio} for aceita.
 * 
 * @author lmoreira
 */
public final class ChangeMinimumForIntegersTrigger extends
  Trigger<SimpleParameter<?>> {
  /**
   * Mnimo ou {@code null} se ele no existir.
   */
  private Integer minimum;

  /**
   * Cria o gatilho.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   * @param minimum O mnimo (Aceita {@code null}).
   */
  public ChangeMinimumForIntegersTrigger(IntegerParameter parameter,
    Condition condition, Integer minimum) {
    super(parameter, condition);
    this.minimum = minimum;
  }

  /**
   * Cria o gatilho.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   * @param minimum O mnimo (Aceita {@code null}).
   */
  public ChangeMinimumForIntegersTrigger(IntegerListParameter parameter,
    Condition condition, Integer minimum) {
    super(parameter, condition);
    this.minimum = minimum;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (!super.equals(obj)) {
      return false;
    }
    ChangeMinimumForIntegersTrigger trigger =
      (ChangeMinimumForIntegersTrigger) obj;
    if (this.minimum == null && trigger.minimum == null) {
      return true;
    }
    return (this.minimum != null && this.minimum.equals(trigger.minimum));
  }

  /**
   * Obtm o mnimo.
   * 
   * @return O mnimo ou {@code null} se ele no existir.
   */
  public Integer getMinimum() {
    return this.minimum;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doAction() {
    SimpleParameter<?> parameter = getParameter();
    if (parameter instanceof IntegerListParameter) {
      IntegerListParameter intListParameter = (IntegerListParameter) parameter;
      intListParameter.setMinimum(getMinimum());
    }
    else if (parameter instanceof IntegerParameter) {
      IntegerParameter intParameter = (IntegerParameter) parameter;
      intParameter.setMinimum(getMinimum());
    }
    else {
      throw new IllegalStateException(MessageFormat.format(
        "O parmetro {0} no  de um tipo vlido.\n"
          + "Tipos permitidos:\n{1};\n{2}.", new Object[] {
            parameter.getLabel(), "real", "lista_de_reais" }));
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void undoAction() {
    // @todo Auto-generated method stub
  }
}
