/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class TableColumn<V>
implements Serializable {
    private V defaultValue;
    private Map<Integer, V> defaultValuesByRowIndex;
    private Set<Integer> rowIndexesWithDefaultValue;
    private String id;
    private boolean isEditable;
    private boolean isOptional;
    private String label;

    protected TableColumn(String id, String label, V defaultValue, boolean isOptional, boolean isEditable) {
        this.setId(id);
        this.setLabel(label);
        this.defaultValuesByRowIndex = new HashMap<Integer, V>();
        this.rowIndexesWithDefaultValue = new HashSet<Integer>();
        this.defaultValue = defaultValue;
        this.isOptional = isOptional;
        this.isEditable = isEditable;
    }

    public final boolean addDefaultValue(int rowIndex, V value) {
        if (rowIndex < 0) {
            throw new IllegalArgumentException("\u00cdndice de linha negativo -> " + rowIndex);
        }
        if (!this.rowIndexesWithDefaultValue.add(rowIndex)) {
            return false;
        }
        this.defaultValuesByRowIndex.put(rowIndex, value);
        return true;
    }

    public final void clearDefaultValues() {
        this.rowIndexesWithDefaultValue.clear();
        this.defaultValuesByRowIndex.clear();
    }

    public abstract SimpleParameterValidator<V> getValidator();

    public abstract V getItemValueFromText(String var1) throws ParseException;

    public abstract String getCommandValue(V var1, CommandLineContext var2);

    public abstract String getItemValueAsText(V var1);

    public abstract Object getValueToExport(V var1);

    public abstract V getValueToImport(Object var1);

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        TableColumn column = (TableColumn)obj;
        return this.getId().equals(column.getId());
    }

    public final V getDefaultValue(int rowIndex) {
        if (rowIndex < 0) {
            throw new IllegalArgumentException("\u00cdndice da linha negativo -> " + rowIndex);
        }
        if (this.rowIndexesWithDefaultValue.contains(rowIndex)) {
            return this.defaultValuesByRowIndex.get(rowIndex);
        }
        return this.defaultValue;
    }

    public final V getDefaultValue() {
        return this.defaultValue;
    }

    public final String getId() {
        return this.id;
    }

    public final String getLabel() {
        return this.label;
    }

    public final Set<Integer> getRowIndexes() {
        return Collections.unmodifiableSet(this.rowIndexesWithDefaultValue);
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public final boolean isEditable() {
        return this.isEditable;
    }

    public final boolean isOptional() {
        return this.isOptional;
    }

    public final String toString() {
        return this.getLabel();
    }

    private void setId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("O par\u00e2metro id est\u00e1 nulo.");
        }
        this.id = id;
    }

    private void setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("O par\u00e2metro label est\u00e1 nulo.");
        }
        this.label = label;
    }
}

