/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.conditions;

import csbase.logic.algorithms.parameters.conditions.Condition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class CompositeOperatorCondition
implements Condition {
    private final List<Condition> conditions;

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        CompositeOperatorCondition condition = (CompositeOperatorCondition)obj;
        return this.conditions.equals(condition.conditions);
    }

    protected final List<Condition> getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    public final int hashCode() {
        return this.conditions.hashCode();
    }

    protected CompositeOperatorCondition(Condition ... conditions) {
        this(Arrays.asList(conditions));
    }

    protected CompositeOperatorCondition(List<Condition> conditions) {
        if (conditions == null) {
            throw new IllegalArgumentException("O par\u00e2metro conditions est\u00e1 nulo.");
        }
        if (conditions.size() < 2) {
            String errorMessage = String.format("O n\u00famero de condi\u00e7\u00f5es tem que ser pelo menos 2, por\u00e9m o n\u00famero atual \u00e9: %d.\n", conditions.size());
            throw new IllegalArgumentException(errorMessage);
        }
        this.conditions = new ArrayList<Condition>(conditions);
    }
}

