/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parsers.EnumerationItemFactory;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.List;

public abstract class AbstractEnumerationParameterParser<T extends SimpleParameter<?>>
extends SimpleParameterParser<T> {
    public static final String ENUMERATION_ELEMENT_MUST_SORT_ATTRIBUTE = "ordenar";
    public static final boolean ENUMERATION_ELEMENT_MUST_SORT_DEFAULT_VALUE = true;
    private EnumerationItemFactory enumerationItemFactory = new EnumerationItemFactory();

    protected AbstractEnumerationParameterParser() {
    }

    @Override
    public T createSimpleParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        List<EnumerationItem> items = this.enumerationItemFactory.loadEnumerationItems(parser, name);
        String defaultItemId = parser.extractAttributeValue("padrao", null);
        boolean mustSort = parser.extractAttributeValueAsBoolean(ENUMERATION_ELEMENT_MUST_SORT_ATTRIBUTE, true);
        return this.createEnumerationParameter(parser, name, label, description, isOptional, isVisible, commandLinePattern, mustSort, items, defaultItemId);
    }

    protected abstract T createEnumerationParameter(XmlParser var1, String var2, String var3, String var4, boolean var5, boolean var6, String var7, boolean var8, List<EnumerationItem> var9, String var10) throws ParseException;

    protected final EnumerationItemFactory getEnumerationItemFactory() {
        return this.enumerationItemFactory;
    }
}

