/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.columns.TableColumnFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractTableParameterFactory
extends SimpleParameterParser<TableParameter> {
    public static final String TABLE_PARAMETER_ELEMENT = "tabela";
    private static final String TABLE_PARAMETER_ELEMENT_DELIMIT_ROWS_ATTRIBUTE = "delimitar_linhas";
    private static final boolean TABLE_PARAMETER_ELEMENT_DELIMIT_ROWS_DEFAULT_VALUE = false;
    private static final String TABLE_PARAMETER_ELEMENT_DELIMIT_TABLE_ATTRIBUTE = "delimitar_tabela";
    private static final boolean TABLE_PARAMETER_ELEMENT_DELIMIT_TABLE_DEFAULT_VALUE = false;
    private static final String TABLE_PARAMETER_ELEMENT_VISIBLE_ROW_COUNT_ATTRIBUTE = "quantidade_de_linhas_visiveis";
    private static final String TABLE_PARAMETER_ELEMENT_MAX_ROW_COUNT_ATTRIBUTE = "quantidade_maxima_de_linhas";
    private static final String TABLE_PARAMETER_ELEMENT_MIN_ROW_COUNT_ATTRIBUTE = "quantidade_minima_de_linhas";
    private static final int TABLE_PARAMETER_ELEMENT_ROW_COUNT_MINIMUM_VALUE = 1;
    private static final String TABLE_PARAMETER_ELEMENT_ROW_COUNT_ATTRIBUTE = "quantidade_de_linhas";
    private static final String CELL_VALUE_ELEMENT = "celula";
    private static final String CELL_VALUE_ELEMENT_COLUMN_ID_ATTRIBUTE = "id_da_coluna";
    private static final String CELL_VALUE_ELEMENT_ROW_INDEX_ATTRIBUTE = "indice_da_linha";
    protected static final String CELL_VALUE_ELEMENT_VALUE_ATTRIBUTE = "valor";
    private Map<String, TableColumnFactory> factoriesByColumnId = new HashMap<String, TableColumnFactory>();

    protected AbstractTableParameterFactory() {
    }

    @Override
    public TableParameter createSimpleParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        boolean delimitTable = parser.extractAttributeValueAsBoolean(TABLE_PARAMETER_ELEMENT_DELIMIT_TABLE_ATTRIBUTE, false);
        boolean delimitRows = parser.extractAttributeValueAsBoolean(TABLE_PARAMETER_ELEMENT_DELIMIT_ROWS_ATTRIBUTE, false);
        Integer rowCount = parser.extractAttributeValueAsInteger(TABLE_PARAMETER_ELEMENT_ROW_COUNT_ATTRIBUTE, null, null, 1);
        Integer visibleRowCount = parser.extractAttributeValueAsInteger(TABLE_PARAMETER_ELEMENT_VISIBLE_ROW_COUNT_ATTRIBUTE, null, null, 1);
        Integer maxRowCount = parser.extractAttributeValueAsInteger(TABLE_PARAMETER_ELEMENT_MAX_ROW_COUNT_ATTRIBUTE, null, null, null);
        Integer minRowCount = parser.extractAttributeValueAsInteger(TABLE_PARAMETER_ELEMENT_MIN_ROW_COUNT_ATTRIBUTE, null, null, null);
        List<TableColumn<?>> columns = this.loadColumns(parser, name, configurator);
        TableParameter parameter = new TableParameter(name, label, description, isOptional, isVisible, commandLinePattern, columns, delimitTable, delimitRows, rowCount, visibleRowCount, minRowCount, maxRowCount);
        return parameter;
    }

    @Override
    public List<Class<? extends Parameter>> getParameterTypes() {
        return Collections.singletonList(TableParameter.class);
    }

    private List<TableColumn<?>> loadColumns(XmlParser parser, String parameterName, SimpleAlgorithmConfigurator configurator) throws ParseException {
        LinkedList columns = new LinkedList();
        if (!parser.goToFirstChild()) {
            throw new ParseException("A lista de colunas da tabela est\u00e1 vazia.");
        }
        do {
            String elementName;
            if ((elementName = parser.getElementName()).equals(CELL_VALUE_ELEMENT)) {
                this.setCellValue(parser, parameterName, columns);
                continue;
            }
            this.createColumn(parser, parameterName, columns, elementName, configurator);
        } while (parser.goToNextSibling());
        parser.goToParent();
        return columns;
    }

    private void createColumn(XmlParser parser, String parameterName, List<TableColumn<?>> columns, String elementName, SimpleAlgorithmConfigurator configurator) throws ParseException {
        TableColumnFactory factory = this.createFactory(elementName);
        if (factory != null) {
            TableColumn<?> column = factory.createColumn(parser, parameterName, configurator);
            this.factoriesByColumnId.put(column.getId(), factory);
            if (columns.contains(column)) {
                throw new ParseException("J\u00e1 existe uma coluna {0}.", column);
            }
            columns.add(column);
        }
    }

    private void setCellValue(XmlParser parser, String parameterName, List<TableColumn<?>> columns) throws ParseException {
        Integer rowIndex = parser.extractAttributeValueAsInteger(CELL_VALUE_ELEMENT_ROW_INDEX_ATTRIBUTE, null, 0);
        String columnId = parser.extractAttributeValue(CELL_VALUE_ELEMENT_COLUMN_ID_ATTRIBUTE);
        TableColumn<?> theColumn = null;
        for (TableColumn<?> aColumn : columns) {
            if (!aColumn.getId().equals(columnId)) continue;
            theColumn = aColumn;
            break;
        }
        if (theColumn == null) {
            throw new ParseException("A coluna {2} da tabela {0} referenciada pela c\u00e9lula {1} {2} n\u00e3o existe na tabela ou ainda n\u00e3o foi definida.", parameterName, rowIndex, columnId);
        }
        TableColumnFactory factory = this.factoriesByColumnId.get(columnId);
        factory.setCellValue(parser, parameterName, theColumn, rowIndex, CELL_VALUE_ELEMENT_VALUE_ATTRIBUTE);
    }

    protected abstract TableColumnFactory createFactory(String var1);
}

