/*
 * ServerGroupInfo.java
 *
 * $Author: taciana $
 * $Revision: 54838 $  - $Date: 2006-08-15 16:42:08 -0300 (Tue, 15 Aug 2006) $
 */
package csbase.logic;

import java.io.Serializable;

/**
 * Representa um grupo de servidores de algoritmos.
 *
 * @author ana
 */
public class ServerGroupInfo implements Serializable {
  /** Nome do grupo */
  private String groupName;
  /** Lista de servidores */
  private String[] servers;
  /** Indica se  o grupo "default" (todos os servidores) */
  private boolean allServers;

  /**
   * Constri a representao do grupo default.
   *
   * @param groupName .
   *
   * @return .
   */
  public static ServerGroupInfo createAllServersGroupInfo(String groupName) {
    return new ServerGroupInfo(groupName, null, true);
  }

  /**
   * Obtm o nome do grupo.
   *
   * @return nome do grupo
   */
  public String getName() {
    return groupName;
  }

  /**
   * Obtm os servidores componentes do grupo.
   *
   * @return vetor contendo os nomes dos servidores
   */
  public String[] getServers() {
    return servers;
  }

  /**
   * Verifica se  o grupo default(todos).
   *
   * @return .
   */
  public boolean containsAllServers() {
    return allServers;
  }

  /**
   * Construtor da representao de um grupo de servidores.
   *
   * @param groupName nome do grupo
   * @param servers servidores
   * @param allServers indica se  o grupo default(todos)
   */
  public ServerGroupInfo(
    String groupName, String[] servers, boolean allServers) {
    this.groupName = groupName;
    this.servers = servers;
    this.allServers = allServers;
  }

  /**
   * Construtor da representao de um grupo de servidores especfico.
   *
   * @param groupName nome do grupo
   * @param servers servidores
   */
  public ServerGroupInfo(String groupName, String[] servers) {
    this(groupName, servers, false);
  }
}
