package csbase.logic.filters;

import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileFilter;

/**
 * Define um filtro que aceita apenas diretrios.
 *
 * @author Rodrigo Carneiro Henrique (rodrigoh)
 */
public final class ProjectFileDirectoryFilter implements ProjectFileFilter {
  private static ProjectFileDirectoryFilter instance;

  private ProjectFileDirectoryFilter() {}

  public static ProjectFileDirectoryFilter getInstance() {
    if (ProjectFileDirectoryFilter.instance == null) {
      ProjectFileDirectoryFilter.instance = new ProjectFileDirectoryFilter();
    }
    return ProjectFileDirectoryFilter.instance;
  }

  public boolean accept(ClientProjectFile file) {
    return file.isDirectory();
  }
}
