/**
 * $Id$
 */

package csbase.logic;

import java.rmi.RemoteException;

import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;

/**
 * Classe responsvel por observar no cliente quando um lock de arquivo  obtido
 * ou expirado.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ClientFileLockListener implements FileLockListenerInterface,
  IMessageListener {

  /**
   * Indica se j chegou a notificao de que o lock foi obtido ou o pedido
   * expirou.
   */
  private boolean gotNotification;

  /**
   * Indica se conseguiu o lock.
   */
  private boolean locked;

  /**
   * Identificado do lock.
   */
  private Object lockId;

  /**
   * Constri o listener que  notificado quando o lock  obtido ou expirado
   * 
   * @param lockId o identificador do lock
   * 
   * @throws RemoteException falha na exportao do objeto
   */
  public ClientFileLockListener(Object lockId) throws RemoteException {
    super();
    this.gotNotification = false;
    this.locked = false;
    this.lockId = lockId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public synchronized final void fileLocked(Object lockId)
    throws RemoteException {
    // Em clientes, no  usado a callback. O evento  enviado pelo MessageService.
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public synchronized final void fileLockExpired(Object lockId)
    throws RemoteException {
    // Em clientes, no  usado a callback. O evento  enviado pelo MessageService.
  }

  /**
   * Espera por uma notificao: de <code>fileLocked</code> ou de
   * <code>fileLockExpired</code>.
   * 
   * @return true se obteve o lock do arquivo
   */
  public synchronized boolean waitLock() {
    while (!gotNotification) {
      try {
        wait();
      }
      catch (InterruptedException e) {
      }
    }
    return locked;
  }

  /**
   * Chegou a notificao de que o lock do arquivo foi obtido ou expirado.
   */
  private synchronized void gotNotification() {
    gotNotification = true;
    notify();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void onMessagesReceived(Message... messages) throws Exception {
    for (Message message : messages) {
      FileLockEvent event = (FileLockEvent) message.getBody();
      if (event.lockId.equals(lockId)) {
        locked = event.lockStatus;
        gotNotification();
        return;
      }
    }
  }
}
