package csbase.logic;

import java.io.Serializable;

/**
 * Esta classe representa as informaes de um arquivo que foi obtido como
 * resultado da pesquisa de arquivos. Este objeto ser utilizado tanto pelo
 * servidor (que fornecer o resultado) como pelo cliente (que exibir este
 * resultado em uma tabela).
 * 
 * @author Tecgraf
 */
public class FileInfoSearchResult implements Serializable {

  /**
   * Nome do arquivo.
   */
  private String fileName;

  /**
   * Path do arquivo relativo ao projeto.
   */
  private String filePath;

  /**
   * Nome do projeto que est associado ao arquivo.
   */
  private String projectName;

  /**
   * Id do projeto que est associado ao arquivo.
   */
  private Object projectId;

  /**
   * Indica se o usurio que fez a busca tem permisso de escrita no projeto.
   */
  private boolean isWritable;

  /**
   * Nome do usurio que possui o arquivo
   */
  private String ownerName;

  /**
   * Construtor.
   * 
   * @param fileName - nome do arquivo.
   * @param filePath - path do arquivo.
   * @param projectName - nome do projeto associado.
   * @param projectId - id do projeto associado.
   * @param ownerName - nome do dono do arquivo
   * @param isWritable - indica se o usurio que fez a busca tem permisso de
   *        escrita no projeto
   */
  public FileInfoSearchResult(String fileName, String filePath,
    String projectName, Object projectId, String ownerName, boolean isWritable) {
    this.fileName = fileName;
    this.filePath = filePath;
    this.projectName = projectName;
    this.projectId = projectId;
    this.ownerName = ownerName;
    this.isWritable = isWritable;
  }

  /**
   * Obtm o id do projeto.
   * 
   * @return id do projeto
   */
  public Object getProjectId() {
    return projectId;
  }

  /**
   * Obtm o id do projeto.
   * 
   * @return id do projeto
   */
  public String getProjectName() {
    return projectName;
  }

  /**
   * Obtm o nome do arquivo.
   * 
   * @return nome do arquivo
   */
  public String getFileName() {
    return fileName;
  }

  /**
   * Obtm o path do arquivo.
   * 
   * @return path do arquivo
   */
  public String getFilePath() {
    return filePath;
  }

  /**
   * Obtm o nome do dono do arquivo
   * 
   * @return nome do dono do arquivo
   */
  public String getOwnerName() {
    return ownerName;
  }

  /**
   * Verifica se o usurio tem acesso de escrita no projeto.
   * 
   * @return <code>true</code> se o usurio pode escrever no projeto
   */
  public boolean isWritable() {
    return isWritable;
  }
}
