package csbase.logic.algorithms.parsers;

import csbase.logic.algorithms.parameters.DoubleColumn;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.SimpleParameterStructure;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.DoubleAttribute;

/**
 * Interface para analisadores de parmetros com
 * valores numricos reais como
 * {@link DoubleParameter},
 * {@link DoubleListParameter} e
 * {@link DoubleColumn}.
 */
public interface DoubleStructureAttributes {


  /**
   * O atributo {@value #DOUBLE_ELEMENT_INCLUDE_MAXIMUM_ATTRIBUTE} dos
   * elementos:
   * <ul>
   * <li>{@link DoubleColumn} de um {@link TableParameter}</li>
   * <li>{@link DoubleListParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * </ul>
   * <p>
   * Indica se o valor mximo deve ser considerado um valor vlido,  opcional,
   * o valor-padro  {@link #DOUBLE_ELEMENT_INCLUDE_MAXIMUM_DEFAULT_VALUE} e 
   * do tipo booleano.
   * </p>
   */
  public static final String DOUBLE_ELEMENT_INCLUDE_MAXIMUM_ATTRIBUTE =
    "incluir_maximo";

  /**
   * O valor-padro para o atributo
   * {@link #DOUBLE_ELEMENT_INCLUDE_MAXIMUM_ATTRIBUTE} dos elementos:
   * <ul>
   * <li>{@link DoubleColumn} de um {@link TableParameter}</li>
   * <li>{@link DoubleListParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * </ul>
   * <p>
   * O seu valor  {@value #DOUBLE_ELEMENT_INCLUDE_MAXIMUM_DEFAULT_VALUE}.
   * </p>
   */
  public static final boolean DOUBLE_ELEMENT_INCLUDE_MAXIMUM_DEFAULT_VALUE =
    true;

  /**
   * O atributo {@value #DOUBLE_ELEMENT_INCLUDE_MINIMUM_ATTRIBUTE} dos
   * elementos:
   * <ul>
   * <li>{@link DoubleColumn} de um {@link TableParameter}</li>
   * <li>{@link DoubleListParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * </ul>
   * <p>
   * Indica se o valor mnimo deve ser considerado um valor vlido,  opcional,
   * o valor-padro  {@link #DOUBLE_ELEMENT_INCLUDE_MINIMUM_DEFAULT_VALUE} e 
   * do tipo booleano.
   * </p>
   */
  public static final String DOUBLE_ELEMENT_INCLUDE_MINIMUM_ATTRIBUTE =
    "incluir_minimo";

  /**
   * O valor-padro para o atributo
   * {@link #DOUBLE_ELEMENT_INCLUDE_MINIMUM_ATTRIBUTE} dos elementos:
   * <ul>
   * <li>{@link DoubleColumn} de um {@link TableParameter}</li>
   * <li>{@link DoubleListParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * </ul>
   * <p>
   * O seu valor  {@value #DOUBLE_ELEMENT_INCLUDE_MINIMUM_DEFAULT_VALUE}.
   * </p>
   */
  public static final boolean DOUBLE_ELEMENT_INCLUDE_MINIMUM_DEFAULT_VALUE =
    true;

  /**
   * O atributo {@value #DOUBLE_ELEMENT_MAXIMUM_ATTRIBUTE} dos elementos:
   * <ul>
   * <li>{@link DoubleColumn} de um {@link TableParameter}</li>
   * <li>{@link DoubleListParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * </ul>
   * <p>
   * Indica o valor mximo,  opcional e  do tipo real.
   * </p>
   */
  public static final String DOUBLE_ELEMENT_MAXIMUM_ATTRIBUTE = "maximo";

  /**
   * O atributo {@value #DOUBLE_ELEMENT_MINIMUM_ATTRIBUTE} dos elementos:
   * <ul>
   * <li>{@link DoubleColumn} de um {@link TableParameter}</li>
   * <li>{@link DoubleListParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * </ul>
   * <p>
   * Indica o valor mnimo,  opcional e  do tipo real.
   * </p>
   */
  public static final String DOUBLE_ELEMENT_MINIMUM_ATTRIBUTE = "minimo";

  /**
   * Cria a estrutura base de parmetros de reais.
   *
   * @param tag nome do parmetro.
   * @param parameterClass classe do parmetro.
   * @return a estrutura do parmetro.
   */
  public default <T extends SimpleParameter<?>> ParameterStructure<T>
  getDoubleStructure(
    String tag, Class<T> parameterClass) {
    ParameterStructure<T> structure =
      new SimpleParameterStructure<>(tag, parameterClass);
    DoubleAttribute maximumAttribute =
      new DoubleAttribute(DOUBLE_ELEMENT_MAXIMUM_ATTRIBUTE, null);
    structure.addAttribute(maximumAttribute);
    structure.addAttribute(
      new BooleanAttribute(DOUBLE_ELEMENT_INCLUDE_MAXIMUM_ATTRIBUTE,
        DOUBLE_ELEMENT_INCLUDE_MAXIMUM_DEFAULT_VALUE));
    DoubleAttribute minimumAttribute =
      new DoubleAttribute(DOUBLE_ELEMENT_MINIMUM_ATTRIBUTE, null);
    minimumAttribute.setMaximumValueAttribute(maximumAttribute);
    structure.addAttribute(minimumAttribute);
    structure.addAttribute(
      new BooleanAttribute(DOUBLE_ELEMENT_INCLUDE_MINIMUM_ATTRIBUTE,
        DOUBLE_ELEMENT_INCLUDE_MINIMUM_DEFAULT_VALUE));
    return structure;
  }
}
