package csbase.logic.algorithms.parsers;

import java.util.ArrayList;
import java.util.List;

import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;

/**
 * Fbrica de parmetros do tipo URL de entrada.
 * 
 * @author Tecgraf
 */
public class InputURLParameterFactory extends URLParameterFactory {

  /**
   * Parser do parmetro mltiplo.
   */
  private InputURLListParameterParser inputURLListParser;

  /**
   * Parser do parmetro simples.
   */
  private InputURLParameterParser inputURLParser;

  /**
   * Construtor.
   */
  public InputURLParameterFactory() {
    inputURLParser = new InputURLParameterParser();
    inputURLListParser = new InputURLListParameterParser();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected InputURLParameterParser createSimpleURLParser() {
    return inputURLParser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected InputURLListParameterParser createURLListParser() {
    return inputURLListParser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<ParameterStructure<?>> getParameterStructures() {
    List<ParameterStructure<?>> types = new ArrayList<>();
    types.add(getSimpleStructure());
    types.add(getMultipleStructure());
    return types;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public BooleanAttribute getAttribute() {
    return new BooleanAttribute(
      URL_PARAMETER_ELEMENT_MULTIPLE_SELECTION_ATTRIBUTE,
      URL_PARAMETER_ELEMENT_MULTIPLE_SELECTION_DEFAULT_VALUE);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ParameterStructure<?> getParameterStructure(boolean value) {
    if (value) {
      return getMultipleStructure();
    }
    return getSimpleStructure();
  }

  /**
   * Obtm a estrutura do parmetro simples.
   * 
   * @return estrutura do parmetro simples.
   */
  private ParameterStructure<?> getSimpleStructure() {
    ParameterStructure<?> structure = inputURLParser.getParameterStructure();
    structure.addAttribute(getAttribute());
    return structure;
  }

  /**
   * Obtm a estrutura do parmetro mltiplo.
   * 
   * @return estrutura do parmetro mltiplo.
   */
  private ParameterStructure<?> getMultipleStructure() {
    ParameterStructure<?> structure = inputURLListParser
      .getParameterStructure();
    structure.addAttribute(getAttribute());
    return structure;
  }

}
