package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;

/**
 * <p>
 * Analisador de {@link IntegerListParameter}.
 * </p>
 *
 * <p>
 * Este parser l os atributos de parmetros do tipo "lista de inteiros". O
 * elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link IntegerListParameter}.
 * </p>
 */
public class IntegerListParameterFactory extends
  SimpleParameterParser<IntegerListParameter> implements
  IntegerStructureAttributes {

  /**
   * <p>
   * O elemento {@value #INTEGER_LIST_PARAMETER_ELEMENT}: indica que o
   * {@link ParameterGroup grupo} que que est descrito no elemento-pai deste
   * elemento ter uma {@link IntegerListParameter parmetro do tipo lista de
   * inteiros}.
   * </p>
   * <p>
   *  filho do elemento {@link ParameterGroup}.
   * </p>
   */
  public static final String INTEGER_LIST_PARAMETER_ELEMENT =
    "lista_de_inteiros";

  /**
   * {@inheritDoc}
   */
  @Override
  public IntegerListParameter createSimpleParameter(XmlParser parser,
    ParsedSimpleParameter definition, ParameterGroup group,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    Integer maximum = definition.getAttributeValue(
      INTEGER_ELEMENT_MAXIMUM_ATTRIBUTE);
    Integer minimum = definition.getAttributeValue(
      INTEGER_ELEMENT_MINIMUM_ATTRIBUTE);
    return new IntegerListParameter(definition.getName(), definition.getLabel(),
      definition.getDescription(), null, definition.isOptional(), definition
        .isVisible(), definition.getCommandLinePattern(), maximum, minimum);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ParameterStructure<IntegerListParameter> getParameterStructure() {
    return getIntegerStructure(INTEGER_LIST_PARAMETER_ELEMENT,
      IntegerListParameter.class);
  }
}
