/*
 * $Id$
 */
package csbase.logic.algorithms.xml.algorithmspack;

import org.xml.sax.InputSource;

import csbase.logic.algorithms.AlgorithmsPack;

import tecgraf.javautils.xml.XMLBasicHandler;
import tecgraf.javautils.xml.XMLUtils;
import tecgraf.javautils.xml.exception.XMLException;

/**
 * Handler XML para leitura de categorias de algoritmos.
 * 
 */
public class XmlAlgorithmsPackHandler extends XMLBasicHandler {

  /**
   * Prefixo do DTD que ser usado pelo servio de algoritmos para validar o
   * metadados do pacote de algoritmos.
   */
  private final String DTD_PREFIX =
    "../csbase/server/services/algorithmservice/xml/";

  /**
   * Constri o handler.
   * 
   * @param algorithmsPack pacote de algoritmos
   * @param dtdPath path ou url que identifica o arquivo de dtd
   */
  public XmlAlgorithmsPackHandler(AlgorithmsPack algorithmsPack, String dtdPath) {
    super(new XmlAlgorithmsPackFactory(algorithmsPack));
    setDTD(dtdPath);
  }

  /**
   * Obtm a referncia para a lista de algoritmos.
   * 
   * @return a referncia para a lista de algoritmos
   */
  final public AlgorithmsPack getAlgorithms() {
    return (AlgorithmsPack) getXMLFactory().getAppContextObject();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public InputSource resolveEntity(String publicId, String systemId)
    throws XMLException {
    String fixUrlPrefix = XMLUtils.fixUrlPrefix(systemId, DTD_PREFIX);
    return new InputSource(fixUrlPrefix);
  }
}
