package csbase.logic.applicationservice;

import java.io.File;
import java.util.StringTokenizer;

/**
 * Utilitrios para o Registry.
 * 
 * @author Tecgraf/PUC-Rio
 */
final public class ApplicationRegistryUtilities {

  /**
   * Obtm o diretrio do <code>PATH</code> onde a aplicao do comando est.
   * 
   * @param cmd comando
   * @return o diretrio do <code>PATH</code> onde o comando est
   */
  static String getCommandPath(final String cmd) {
    String command = cmd;
    System.getProperties();
    final String APP_CMD_SEP = " ";

    StringTokenizer stringTokenizer = new StringTokenizer(command, APP_CMD_SEP);
    if (stringTokenizer.hasMoreTokens()) {
      command = stringTokenizer.nextToken();
      return findFileOnSystemPath(command);
    }
    return null;
  }

  /**
   * Busca de arquivo (se existe)
   * 
   * @param fileName o nome do arquivo
   * @return o diretrio onde encontrou o arquivo
   */
  private static String findFileOnSystemPath(String fileName) {
    if (fileName == null) {
      throw new IllegalArgumentException("Arquivo no pode ser nulo.");
    }
    String path = System.getenv("PATH");
    return findFileOnPaths(fileName, path);
  }

  /**
   * Busca de arquivo em paths
   * 
   * @param fileName o nome do arquivo
   * @param path o path
   * @return o path onde o arquivo foi encontrado
   */
  private static String findFileOnPaths(String fileName, String path) {
    String pths = path;
    if (pths != null) {
      if (pths.equals("")) {
        pths = "."; // Diretrio corrente
      }
      final StringTokenizer st = new StringTokenizer(pths, File.pathSeparator);
      while (st.hasMoreTokens()) {
        String dir = st.nextToken();
        String nextPath = dir + File.separator + fileName;
        File file = new File(nextPath);
        if (file.exists()) {
          return dir;
        }
      }
    }
    return null;
  }
}
