/*
 * $Id$
 */
package csbase.logic;

import java.util.Comparator;

/**
 * A classe <code>ProjectFileComparator</code> implementa o Comparator para o
 * ProjectFile. Ordenao: diretrio pai quando existir (..), seguido dos
 * diretrios ordenados alfabeticamente, seguidos dos arquivos ordenados
 * alfabeticamente.
 * 
 * @author Tecgraf
 */
public class ClientProjectFileComparator implements
  Comparator<ClientProjectFile> {

  /**
   * {@inheritDoc}
   */
  @Override
  public int compare(ClientProjectFile file1, ClientProjectFile file2) {
    if (file1.isDirectory()) {
      if (file2.isDirectory()) {
        return file1.getName().compareToIgnoreCase(file2.getName());
      }
      return -1;
    }
    if (file2.isDirectory()) {
      return 1;
    }
    return file1.getName().compareToIgnoreCase(file2.getName());
  }
}
