package csbase.logic;

/**
 * Classe que representa os dados de mensagem de sucesso na execuo de um
 * comando em um SGA. Essa notificao indica que o comando terminou sua
 * execuo com sucesso.
 * 
 * @author Tecgraf
 */
public class CommandSuccessNotification extends
  ExtendedCommandFinishedNotification {

  /**
   * Indica se o comando gerou warnings de execuo.
   */
  private final boolean hasWarnings;

  /**
   * {@inheritDoc}
   */
  @Override
  protected String getStatusString() {
    return "CMD/SUCCESS";
  }

  /**
   * Constri o evento de trmino de comando.
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param commandId identificador do comando.
   * @param cmdDesc descrio do comando.
   * @param tip Dica para auxiliar a identificao do algoritmo do comando.
   * @param elapsedTimeSec tempo de parede.
   * @param userTimeSec tempo em modo usurio.
   * @param cpuTimeSec tempo em modo sistema.
   * @param startTime Hora de incio
   * @param endTime Hora de trmino.
   * @param execHost Servidor de execuo.
   * @param hasWarnings Indica se o comando gerou warnings de execuo.
   * @param projectId identificador do projeto
   * @param finalizationInfo Informaes sobre a finalizao do comando.
   */
  public CommandSuccessNotification(String sender, Object commandId,
    String cmdDesc, String tip, Integer elapsedTimeSec, Integer userTimeSec,
    Integer cpuTimeSec, long startTime, long endTime, String execHost,
    boolean hasWarnings, Object projectId,
    CommandFinalizationInfo finalizationInfo) {
    super(sender, commandId, cmdDesc, tip, elapsedTimeSec, userTimeSec,
      cpuTimeSec,
      startTime, endTime, execHost, projectId, finalizationInfo);
    this.hasWarnings = hasWarnings;
  }

  /**
   * Indica se o comando gerou warnings durante sua execuo.
   *
   * @return verdadeiro se o comando gerou warnings ou falso, caso contrrio.
   */
  public boolean hasWarnings() {
    return hasWarnings;
  }
}
