/**
 * $Id$
 */
package csbase.logic;

import csbase.remote.RemoteEvent;

/**
 * Evento para indicar a clientes o estado da solicitao de um bloqueio de
 * arquivo da rea de projetos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FileLockEvent extends RemoteEvent {
  /**
   * Identificador da solicitao de bloqueio.
   */
  public Object lockId;
  /**
   * Estado da solicitao. {@code True} indica que o bloqueio foi obtido e
   * {@code false} caso contrrio.
   */
  public boolean lockStatus;

  /**
   * Construtor.
   * 
   * @param lockId identificador da solicitao de bloqueio
   * @param lockStatus estado do bloqueio
   */
  public FileLockEvent(Object lockId, boolean lockStatus) {
    this.lockId = lockId;
    this.lockStatus = lockStatus;
  }
}
