/**
 * $Id$
 */
package csbase.logic;

import java.io.Serializable;

/**
 * A classe <code>LogFileInfo</code> encapsula as informaes bsicas de um
 * arquivo de log
 * 
 * @author Tecgraf
 */
public class LogFileInfo implements Serializable {
  /**
   * Nome do arquivo
   */
  public final String name;

  /**
   * Indicador se  um diretrio
   */
  public final boolean isDirectory;

  /**
   * Indicador se  uma referncia para o diretrio pai
   */
  public final boolean isParent;

  /**
   * Caminho completo do arquivo
   */
  public final String path;

  /**
   * Tamanho do arquivo
   */
  public final long size;

  /**
   * Data de modificao do arquivo
   */
  public final long lastModified;

  /**
   * Construtor
   * 
   * @param name nome
   * @param isDirectory indicador de diretrio
   * @param path caminho completo
   * @param size tamanho
   * @param lastModified data de modificao
   */
  public LogFileInfo(String name, boolean isDirectory, String path, long size,
    long lastModified) {
    this(name, isDirectory, false, path, size, lastModified);
  }

  public LogFileInfo() {
    this("..", false, true, "", -1, -1);
  }

  public LogFileInfo(String name, boolean isDirectory, boolean isParent,
    String path, long size, long lastModified) {
    this.name = name;
    this.isDirectory = isDirectory;
    this.isParent = isParent;
    this.path = path;
    this.size = size;
    this.lastModified = lastModified;
  }
}
