/*
 * ObserverData.java
 * 
 * $Id$
 */
package csbase.logic;

import csbase.exception.ServiceFailureException;
import csbase.remote.RemoteObserver;

/**
 * A classe <code>ObserverData</code> representa um observador remoto e seu
 * argumento.
 */
public class ObserverData {
  /**
   * Observador remoto.
   */
  public RemoteObserver observer;
  /**
   * Argumento do observador remoto.
   */
  public Object arg;

  /**
   * Construtor.
   * 
   * @param observer observador remoto
   * @param arg argumento do observador remoto
   */
  public ObserverData(RemoteObserver observer, Object arg) {
    if (observer == null) {
      throw new ServiceFailureException("ObserverData criado sem observador.");
    }
    this.observer = observer;
    this.arg = arg;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (!(obj instanceof ObserverData)) {
      return false;
    }
    ObserverData obsData = (ObserverData) obj;
    return this.observer.equals(obsData.observer)
      && (this.arg == obsData.arg || (this.arg != null && this.arg
        .equals(obsData.arg)));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    int hash = this.observer.hashCode();
    if (this.arg != null) {
      hash += this.arg.hashCode();
    }
    return hash;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    StringBuffer str = new StringBuffer();
    str.append(this.observer.toString());
    if (this.arg != null) {
      str.append(" (arg = ");
      str.append(this.arg.toString());
      str.append(")");
    }
    return str.toString();
  }
}