package csbase.logic;

import csbase.remote.RemoteEvent;

/**
 * A classe <code>ProjectUserEvent</code> representa um evento ocorrido no
 * ProjectService. Os eventos podem ser de criao ou
 * remoo de algum projeto.
 *
 * @author $Author$
 * @version $Revision$
 */
public class ProjectUserEvent extends RemoteEvent {
  /** O evento de criao de um projeto no ProjectService. */
  public static final int CREATE = 1;
  /** O evento de remoo de um objeto no ProjectService. */
  public static final int DELETE = 2;

  public int type;
  /** Indica o objeto resultante do evento ocorrido. */
  public Object item;

  /**
   * Cria o objeto que representa um evento ocorrido no 
   * ProjectService.
   * @param type a ao ocorrida
   * @param item o objeto resultante da ao
   */
  public ProjectUserEvent(int type, Object item) {
    this.type = type;
    this.item = item;
  }
}
