package csbase.logic.algorithms.parameters;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;

import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.logic.algorithms.parsers.elements.IElementStructure;

/**
 * Registro dos parmetros de um sistema.
 */
public interface ParameterRegistry extends Serializable {

  /**
   * Obtm um mapa com as fbricas dos parmetros do sistema.
   *
   * @return o mapa de fbricas.
   */
  public Map<String, ParameterFactory> getParameterFactories();

  /**
   * Obtm a documentao de um elemento.
   * 
   * @param structure Estrutura do elemento.
   * @param locale Idioma para internacionalizao.
   * @return documentao de um elemento.
   */
  public ParameterDocumentation getParameterDocumentation(
    IElementStructure<?> structure, Locale locale);

}
