/*
 * $Id$
 */
package csbase.logic.algorithms.parameters.conditions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Condio que pode ser definida atravs de um operador e vrias condies
 * simples.
 * 
 * @author Tecgraf/PUC-Rio
 */
public abstract class CompositeOperatorCondition implements Condition {
  /**
   * Lista de condies.
   */
  private final List<Condition> conditions;

  /**
   * {@inheritDoc}
   */
  @Override
  public final boolean equals(final Object obj) {
    if (obj == null) {
      return false;
    }
    if (!getClass().equals(obj.getClass())) {
      return false;
    }
    final CompositeOperatorCondition condition =
      (CompositeOperatorCondition) obj;
    return conditions.equals(condition.conditions);
  }

  /**
   * Retorna a lista de condies.
   * 
   * @return a lista
   */
  protected final List<Condition> getConditions() {
    return Collections.unmodifiableList(conditions);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final int hashCode() {
    return conditions.hashCode();
  }

  /**
   * Construtor
   * 
   * @param conditions condies
   */
  protected CompositeOperatorCondition(final Condition... conditions) {
    this(Arrays.asList(conditions));
  }

  /**
   * Construtor
   * 
   * @param conditions lista de condies.
   */
  protected CompositeOperatorCondition(final List<Condition> conditions) {
    if (conditions == null) {
      throw new IllegalArgumentException("O parmetro conditions est nulo.");
    }
    if (conditions.size() < 2) {
      final String errorMessage =
        String.format("O nmero de condies tem que ser pelo menos 2, "
          + "porm o nmero atual : %d.\n", conditions.size());
      throw new IllegalArgumentException(errorMessage);
    }
    this.conditions = new ArrayList<Condition>(conditions);
  }
}
