/*
 * $Id$
 */

package csbase.logic.filetransferservice;

import java.io.Serializable;

import csbase.remote.FileTransferServiceInterface;

/**
 * Conexo para o servio de transferncia de arquivos.
 * 
 * @author Tecgraf/PUC-Rio
 * @see FileTransferServiceInterface
 */
public class FileTransferConnection implements Serializable {

  /**
   * Tipo da conexo.
   */
  final private FileTransferProtocol protocol;

  /**
   * Id do usurio CSBASE
   */
  final private Object userId;

  /**
   * Identificador do projeto do usurio.
   */
  final private Object projectId;

  /**
   * Nome/endereo do servidor
   */
  final private String serverName;

  /**
   * Senha
   */
  final private String password;

  /**
   * Nome do usurio no servidor
   */
  final private String userName;

  /**
   * Path para o conceito de HOME
   */
  final private String homePath;

  /**
   * Consulta a senha
   * 
   * @return a senha
   */
  public final String getPassword() {
    return password;
  }

  /**
   * Consulta o id do projeto do usurio
   * 
   * @return o id
   */
  public final Object getProjectId() {
    return projectId;
  }

  /**
   * Consulta o tipo da conexo
   * 
   * @return o tipo
   */
  public final FileTransferProtocol getProtocol() {
    return protocol;
  }

  /**
   * Consulta o nome/endereo do servidor
   * 
   * @return o nome/endereo
   */
  public final String getServerName() {
    return serverName;
  }

  /**
   * Consulta o id do usurio
   * 
   * @return o id
   */
  public final Object getUserId() {
    return userId;
  }

  /**
   * Consulta o nome de usurio no servidor
   * 
   * @return o nome
   */
  public final String getUserName() {
    return userName;
  }

  /**
   * @return o campo homeString
   */
  public final String getHomePath() {
    return homePath;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return userName + "@" + serverName + " (" + protocol + ")";
  }

  /**
   * Construtor
   * 
   * @param protocol tipo da conexo.
   * @param serverName nome do servidor remoto
   * @param userId id do usurio CSBASE
   * @param password senha do usurio remoto
   * @param projectId projeto CSBASE
   * @param userName nome do usurio remoto
   * @param homePath path para o home
   */
  public FileTransferConnection(final FileTransferProtocol protocol,
    final String serverName, final String userName, final String password,
    final Object userId, final Object projectId, final String homePath) {
    this.protocol = protocol;
    this.serverName = serverName;
    this.userId = userId;
    this.userName = userName;
    this.password = password;
    this.projectId = projectId;
    this.homePath = homePath;
  }
}
