/*
 * NotificationServiceInterface.java
 *
 * $Author$
 * $Revision$  - $Date$
 */
package csbase.remote;

import java.rmi.RemoteException;

/**
 * Interface remota para acesso ao Servio de Notificao.
 */
public interface NotificationServiceInterface extends ServiceInterface, RemoteObservable {
  /** Nome do servio para o <code>ServiceManager</code> */
  public static final String SERVICE_NAME = "NotificationService";

  /**
   * Envia uma notificao de texto para um conjunto de usurios. Caso a lista
   * de destinatrios seja nula, a mensagem  enviada para todos os usurios.
   * Uma mensagem pode ser voltil, o que significa que se o usurio no estiver
   * apto a receb-la de imediato (por exemplo, se ele no estiver usando o
   * sistema no momento), a mensagem  descartada. Mensagens no volteis so
   * aramazenadas para serem entregues ao destinatrio quando possvel.
   * 
   * @param userIds Lista de usurios destinatrios, ou null para todos os
   *        usurios.
   * @param content Contedo da mensagem.
   * @param mustPopUp Indica se a mensagem deve ser exibida atravs de um
   *        dilogo pop-up para o destinatrio.
   * @param volFlag Indica se a mensagem  voltil (true) ou no (false).
   * 
   * @throws RemoteException Em caso de falha.
   */
  public void notifyTo(Object[] userIds, String content, boolean mustPopUp,
    boolean volFlag)
  throws RemoteException;
}
