/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.conditions;

import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;

public final class SimpleCondition
implements Condition {
    private final String parameterName;
    private final Object value;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        SimpleCondition condition = (SimpleCondition)obj;
        String conditionParameterName = condition.getParameterName();
        if (!this.parameterName.equals(conditionParameterName)) {
            return false;
        }
        Object conditionValue = condition.getValue();
        if (this.value == null && conditionValue == null) {
            return true;
        }
        return this.value != null && this.value.equals(conditionValue);
    }

    @Override
    public boolean evaluate(SimpleAlgorithmConfigurator configurator) {
        if (configurator == null) {
            String err = MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "version");
            throw new IllegalArgumentException(err);
        }
        SimpleParameter<?> parameter = configurator.getSimpleParameter(this.parameterName);
        if (parameter == null) {
            String fmt = LNG.get((String)"csbase.logic.algorithms.parameters.CompositeOperatorCondition");
            String err = MessageFormat.format(fmt, this.parameterName, configurator);
            throw new IllegalStateException(err);
        }
        Object currentValue = parameter.getValue();
        if (this.value == null && currentValue == null) {
            return true;
        }
        return this.value != null && this.value.equals(currentValue);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.parameterName.hashCode();
    }

    public String toString() {
        String toString = "----------\n";
        toString = toString + "Classe = " + this.getClass().getName() + "\n";
        toString = toString + "Parametro = " + this.getParameterName() + "\n";
        toString = toString + "Valor = " + this.getValue() + "\n";
        toString = toString + "----------\n";
        return toString;
    }

    public SimpleCondition(String parameterName, Object value) {
        if (parameterName == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameterName"));
        }
        this.parameterName = parameterName;
        this.value = value;
    }
}

