/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.elements;

import csbase.logic.algorithms.parsers.elements.IElementStructure;
import csbase.logic.algorithms.parsers.elements.attributes.IElementAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ElementStructure<T>
implements IElementStructure<T> {
    private final Map<String, IElementAttribute<?>> attributeMap = new HashMap();
    private final String name;
    private final List<IElementStructure<?>> children;
    private final Class<T> parameterClass;

    public ElementStructure(String name, Class<T> parameterClass) {
        this(name, parameterClass, new ArrayList());
    }

    public ElementStructure(String name, Class<T> parameterClass, List<IElementStructure<?>> children) {
        this.name = name;
        this.parameterClass = parameterClass;
        this.children = children;
    }

    public void addChild(IElementStructure childStructure) {
        this.children.add(childStructure);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addAttribute(IElementAttribute<?> attribute) {
        this.attributeMap.put(attribute.getName(), attribute);
    }

    public IElementAttribute<?> getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    @Override
    public List<IElementAttribute<?>> getAttributes() {
        return new ArrayList(this.attributeMap.values());
    }

    @Override
    public List<IElementStructure<?>> getChildElements() {
        return this.children;
    }

    @Override
    public Class<T> getElementClass() {
        return this.parameterClass;
    }
}

