/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.filetransferservice;

import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferRequestStatus;
import csbase.logic.filetransferservice.FileTransferRequestType;
import java.io.Serializable;

public final class FileTransferRequest
implements Serializable {
    private final String id;
    private final FileTransferRequestType type;
    private final FileTransferConnection connection;
    private final String remoteFilePath;
    private final String[] localFilePath;
    private long queueTime = -1L;
    private long currentTime = -1L;
    private long startTime = -1L;
    private FileTransferRequestStatus status = FileTransferRequestStatus.NONE;
    private long endTime = -1L;
    private String errorMessage = null;
    private long totalBytesTransferred = 0L;
    private final long totalBytesSize;

    public final void addTransferredSize(long bytesTransferred) {
        this.totalBytesTransferred += bytesTransferred;
        this.currentTime = System.currentTimeMillis();
    }

    public final FileTransferConnection getConnection() {
        return this.connection;
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final String getId() {
        return this.id;
    }

    public final String[] getLocalFilePath() {
        return this.localFilePath;
    }

    public double getPercentage() {
        if (this.totalBytesSize <= 0L) {
            return -1.0;
        }
        double ratio = (double)this.totalBytesTransferred / (double)this.totalBytesSize;
        return ratio * 100.0;
    }

    public final long getQueueTime() {
        return this.queueTime;
    }

    public final String getRemoteFilePath() {
        return this.remoteFilePath;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final synchronized FileTransferRequestStatus getStatus() {
        return this.status;
    }

    public final long getTransferredSize() {
        return this.totalBytesTransferred;
    }

    public final double getGlobalTransferRateKBytesSec() {
        if (this.totalBytesTransferred < 0L) {
            return -1.0;
        }
        if (this.status != FileTransferRequestStatus.RUNNING) {
            return -2.0;
        }
        long dt = (this.currentTime - this.getStartTime()) / 1000L;
        return (double)this.totalBytesTransferred / 1024.0 / (double)dt;
    }

    public final long getTotalBytesSize() {
        return this.totalBytesSize;
    }

    public final FileTransferRequestType getType() {
        return this.type;
    }

    public final synchronized void markCancelled() {
        this.status = FileTransferRequestStatus.INTERRUPTED;
        this.endTime = System.currentTimeMillis();
    }

    public void markDeleted() {
        this.status = FileTransferRequestStatus.NONE;
    }

    public final synchronized void markEnd() {
        if (this.status == FileTransferRequestStatus.ERROR) {
            return;
        }
        if (this.status == FileTransferRequestStatus.INTERRUPTED) {
            return;
        }
        this.status = FileTransferRequestStatus.FINISHED;
        this.endTime = System.currentTimeMillis();
        this.totalBytesTransferred = this.totalBytesSize;
    }

    public final synchronized void markError(String msg) {
        this.status = FileTransferRequestStatus.ERROR;
        this.endTime = System.currentTimeMillis();
        this.errorMessage = msg;
    }

    public final synchronized void markQueued() {
        this.status = FileTransferRequestStatus.QUEUED;
        this.queueTime = System.currentTimeMillis();
    }

    public final synchronized void markRunning() {
        this.status = FileTransferRequestStatus.RUNNING;
        this.startTime = System.currentTimeMillis();
    }

    public FileTransferRequest(FileTransferRequestType requestType, FileTransferConnection connection, String remoteFilePath, String[] localFilePath, long size) {
        this.type = requestType;
        this.connection = connection;
        this.remoteFilePath = remoteFilePath;
        this.localFilePath = localFilePath;
        this.status = FileTransferRequestStatus.NONE;
        this.totalBytesSize = size;
        long milis = System.currentTimeMillis();
        String userName = connection.getUserName();
        Object projectId = connection.getProjectId();
        String prefix = userName + "::" + projectId + "::" + remoteFilePath;
        this.id = "[[" + prefix + "::" + (Object)((Object)requestType) + "::" + milis + "]]";
    }
}

